/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.http;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Headers {
    public static final Headers EMPTY = new Headers(Collections.emptyMap());
    private final Map<String, String> headersMap;

    public Headers() {
        this(new LinkedHashMap<String, String>());
    }

    private Headers(Map<String, String> headersMap) {
        this.headersMap = headersMap;
    }

    @NotNull
    public Headers copy() {
        return new Headers(new LinkedHashMap<String, String>(this.headersMap));
    }

    @NotNull
    public Headers add(@NotNull String key, @Nullable Object value) {
        try {
            String encodedValue = URLEncoder.encode(String.valueOf(value), "UTF-8");
            this.headersMap.compute(key, (k, v) -> v != null ? v + "," + encodedValue : encodedValue);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this;
    }

    @NotNull
    public Headers set(@NotNull String key, @Nullable Object value) {
        try {
            String encodedValue = URLEncoder.encode(String.valueOf(value), "UTF-8");
            this.headersMap.put(key, encodedValue);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this;
    }

    @NotNull
    public Map<String, String> getAsMap() {
        return this.headersMap;
    }
}

