/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.callback.data.model.gson.payment;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.callback.data.model.payment.Payment;
import ru.easydonate.easypayments.libs.easydonate4j.callback.data.model.payment.PaymentType;
import ru.easydonate.easypayments.libs.easydonate4j.callback.data.model.purchase.PurchasedProduct;
import ru.easydonate.easypayments.libs.easydonate4j.callback.data.model.server.Server;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.Implementing;
import ru.easydonate.easypayments.libs.easydonate4j.util.Wrapper;
import ru.easydonate.easypayments.libs.gson.annotations.SerializedName;

@Implementing(value=Payment.class)
public class PaymentModel
implements Payment {
    @SerializedName(value="payment_id")
    private int id;
    @SerializedName(value="shop_id")
    private int shopId;
    @SerializedName(value="customer")
    private String customer;
    @SerializedName(value="email")
    private String email;
    @SerializedName(value="cost")
    private double purchaseCost;
    @SerializedName(value="income")
    private double serviceComission;
    @SerializedName(value="payment_type")
    private String paymentTypeRaw;
    @SerializedName(value="products")
    private List<PurchasedProduct> products;
    @SerializedName(value="server")
    private Server server;
    @SerializedName(value="created_at")
    private LocalDateTime createdAt;
    @SerializedName(value="updated_at")
    private LocalDateTime updatedAt;
    @SerializedName(value="signature")
    private String signature;

    @NotNull
    public Optional<String> getEmail() {
        return Wrapper.wrapNullable(this.email);
    }

    @NotNull
    public PaymentType getPaymentType() {
        return PaymentType.getByKey((String)this.paymentTypeRaw);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentModel that = (PaymentModel)o;
        return this.id == that.id && this.shopId == that.shopId && Double.compare(that.purchaseCost, this.purchaseCost) == 0 && Double.compare(that.serviceComission, this.serviceComission) == 0 && Objects.equals(this.customer, that.customer) && Objects.equals(this.email, that.email) && Objects.equals(this.paymentTypeRaw, that.paymentTypeRaw) && Objects.equals(this.products, that.products) && Objects.equals(this.server, that.server) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.updatedAt, that.updatedAt) && Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.shopId, this.customer, this.email, this.purchaseCost, this.serviceComission, this.paymentTypeRaw, this.products, this.server, this.createdAt, this.updatedAt, this.signature);
    }

    @NotNull
    public String toString() {
        return "PaymentModel{id=" + this.id + ", shopId=" + this.shopId + ", customer='" + this.customer + '\'' + ", email='" + this.email + '\'' + ", purchaseCost=" + this.purchaseCost + ", serviceComission=" + this.serviceComission + ", paymentTypeRaw='" + this.paymentTypeRaw + '\'' + ", products=" + this.products + ", server=" + this.server + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", signature='" + this.signature + '\'' + '}';
    }

    public int getId() {
        return this.id;
    }

    public int getShopId() {
        return this.shopId;
    }

    public String getCustomer() {
        return this.customer;
    }

    public double getPurchaseCost() {
        return this.purchaseCost;
    }

    public double getServiceComission() {
        return this.serviceComission;
    }

    public String getPaymentTypeRaw() {
        return this.paymentTypeRaw;
    }

    public List<PurchasedProduct> getProducts() {
        return this.products;
    }

    public Server getServer() {
        return this.server;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public String getSignature() {
        return this.signature;
    }
}

