/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.callback.data.model.gson.mass.sale;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.callback.data.model.mass.sale.MassSale;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.Implementing;
import ru.easydonate.easypayments.libs.easydonate4j.util.Wrapper;
import ru.easydonate.easypayments.libs.gson.annotations.SerializedName;

@Implementing(value=MassSale.class)
public class MassSaleModel
implements MassSale {
    @SerializedName(value="id")
    private int id;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="sale")
    private double discountPercent;
    @SerializedName(value="starts_at")
    private LocalDateTime startsAt;
    @SerializedName(value="expires_at")
    private LocalDateTime expiresAt;
    @SerializedName(value="created_at")
    private LocalDateTime createdAt;
    @SerializedName(value="updated_at")
    private LocalDateTime updatedAt;

    @NotNull
    public Optional<LocalDateTime> getStartsAt() {
        return Wrapper.wrapNullable(this.startsAt);
    }

    @NotNull
    public Optional<LocalDateTime> getExpiresAt() {
        return Wrapper.wrapNullable(this.expiresAt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MassSaleModel that = (MassSaleModel)o;
        return this.id == that.id && Double.compare(that.discountPercent, this.discountPercent) == 0 && Objects.equals(this.name, that.name) && Objects.equals(this.startsAt, that.startsAt) && Objects.equals(this.expiresAt, that.expiresAt) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.updatedAt, that.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.discountPercent, this.startsAt, this.expiresAt, this.createdAt, this.updatedAt);
    }

    @NotNull
    public String toString() {
        return "MassSaleModel{id=" + this.id + ", name='" + this.name + '\'' + ", discountPercent=" + this.discountPercent + ", startsAt=" + this.startsAt + ", expiresAt=" + this.expiresAt + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public double getDiscountPercent() {
        return this.discountPercent;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }
}

