/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.api.v3.response;

import org.jetbrains.annotations.NotNull;

public enum ResponseErrorType {
    UNKNOWN(0, "<unknown error>"),
    SHOP_NOT_FOUND(1, "Shop not found"),
    ELEMENT_NOT_FOUND(2, "Requested element not found"),
    MISSING_REQUIRED_PARAMETERS(3, "Missing required request parameter(s)"),
    WRONG_PARAMETER_VALUE_FORMAT(4, "Some of parameter values have a wrong format"),
    PLUGIN_IS_DISABLED(5, "This plugin is disabled"),
    PLUGIN_INTERNAL_ERROR(6, "An internal plugin error was occured");

    private final int errorCode;
    private final String description;

    @NotNull
    public static ResponseErrorType getByNumber(int errorCode) {
        for (ResponseErrorType responseErrorCode : ResponseErrorType.values()) {
            if (responseErrorCode.getErrorCode() != errorCode) continue;
            return responseErrorCode;
        }
        return UNKNOWN;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getDescription() {
        return this.description;
    }

    private ResponseErrorType(int errorCode, String description) {
        this.errorCode = errorCode;
        this.description = description;
    }
}

