/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.easydonate.surcharge;

import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.client.EasyDonateClient;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.AbstractPlugin;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.PluginRequestExecutor;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.PluginType;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.easydonate.surcharge.SurchargeDiscount;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.easydonate.surcharge.SurchargeDiscountsList;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.easydonate.surcharge.SurchargePluginSettings;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.plugin.easydonate.surcharge.SurchargeGetDiscountResponse;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.plugin.easydonate.surcharge.SurchargeGetDiscountsListResponse;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.plugin.easydonate.surcharge.SurchargeGetSettingsResponse;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpRequestException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpResponseException;
import ru.easydonate.easypayments.libs.easydonate4j.http.QueryParams;
import ru.easydonate.easypayments.libs.easydonate4j.util.Validate;

public final class SurchargePlugin
extends AbstractPlugin {
    public SurchargePlugin(@NotNull EasyDonateClient client, @NotNull PluginRequestExecutor requestExecutor) {
        super(client, requestExecutor, PluginType.SURCHARGE);
    }

    @Override
    @NotNull
    public SurchargePluginSettings getSettings() throws HttpRequestException, HttpResponseException {
        return (SurchargePluginSettings)this.requestExecutor.executeRequest(SurchargeGetSettingsResponse.class);
    }

    @NotNull
    public SurchargeDiscountsList getDiscountsList(@NotNull String customer) throws HttpRequestException, HttpResponseException {
        Validate.notNull(customer, "customer");
        QueryParams queryParams = new QueryParams().add("username", customer);
        return (SurchargeDiscountsList)this.requestExecutor.executeRequest(SurchargeGetDiscountsListResponse.class, queryParams);
    }

    @NotNull
    public SurchargeDiscount getDiscount(@NotNull String customer, int productId) throws HttpRequestException, HttpResponseException {
        Validate.notNull(customer, "customer");
        Validate.isTrue(productId > 0, "'productId' must be greater than 0!", new Object[0]);
        QueryParams queryParams = new QueryParams().add("username", customer).add("product_id", productId);
        return (SurchargeDiscount)this.requestExecutor.executeRequest(SurchargeGetDiscountResponse.class, queryParams);
    }
}

