/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.gson.shop.purchase;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.gson.shop.purchase.FilledAdditionalFieldModel;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.ProductType;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.purchase.Discounts;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.purchase.FilledAdditionalField;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.purchase.PurchasedProduct;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.Implementing;
import ru.easydonate.easypayments.libs.easydonate4j.util.Wrapper;
import ru.easydonate.easypayments.libs.gson.annotations.JsonAdapter;
import ru.easydonate.easypayments.libs.gson.annotations.SerializedName;

@Implementing(value=PurchasedProduct.class)
public class PurchasedProductModel
implements PurchasedProduct {
    @SerializedName(value="id")
    private int id;
    @SerializedName(value="product_id")
    private int productId;
    @SerializedName(value="payment_id")
    private int paymentId;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="type")
    private String typeRaw;
    @SerializedName(value="price")
    private double price;
    @SerializedName(value="number")
    private long defaultAmount;
    @SerializedName(value="amount")
    private long boughtAmount;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="old_price")
    private Double oldPrice;
    @SerializedName(value="image")
    private String iconImage;
    @SerializedName(value="first_delete")
    private boolean oneTimePurchasable;
    @SerializedName(value="commands")
    private List<String> commands;
    @SerializedName(value="additional_fields")
    @JsonAdapter(value=FilledAdditionalFieldModel.ListDeserializer.class)
    private List<FilledAdditionalField> additionalFields;
    @SerializedName(value="sales")
    private Discounts discounts;
    @SerializedName(value="created_at")
    private LocalDateTime createdAt;
    @SerializedName(value="updated_at")
    private LocalDateTime updatedAt;

    @Override
    @NotNull
    public ProductType getType() {
        return ProductType.getByKey(this.typeRaw);
    }

    @Override
    @NotNull
    public Optional<String> getDescription() {
        return Wrapper.wrapNullable(this.description);
    }

    @Override
    @NotNull
    public OptionalDouble getOldPrice() {
        return Wrapper.wrapNullableDouble(this.oldPrice);
    }

    @Override
    @NotNull
    public Optional<Discounts> getDiscounts() {
        return Wrapper.wrapNullable(this.discounts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PurchasedProductModel that = (PurchasedProductModel)o;
        return this.id == that.id && this.productId == that.productId && this.paymentId == that.paymentId && Double.compare(that.price, this.price) == 0 && this.defaultAmount == that.defaultAmount && this.boughtAmount == that.boughtAmount && this.oneTimePurchasable == that.oneTimePurchasable && Objects.equals(this.name, that.name) && Objects.equals(this.typeRaw, that.typeRaw) && Objects.equals(this.description, that.description) && Objects.equals(this.oldPrice, that.oldPrice) && Objects.equals(this.iconImage, that.iconImage) && Objects.equals(this.commands, that.commands) && Objects.equals(this.additionalFields, that.additionalFields) && Objects.equals(this.discounts, that.discounts) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.updatedAt, that.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.productId, this.paymentId, this.name, this.typeRaw, this.price, this.defaultAmount, this.boughtAmount, this.description, this.oldPrice, this.iconImage, this.oneTimePurchasable, this.commands, this.additionalFields, this.discounts, this.createdAt, this.updatedAt);
    }

    @NotNull
    public String toString() {
        return "PurchasedProductModel{id=" + this.id + ", productId=" + this.productId + ", paymentId=" + this.paymentId + ", name='" + this.name + '\'' + ", typeRaw='" + this.typeRaw + '\'' + ", price=" + this.price + ", defaultAmount=" + this.defaultAmount + ", boughtAmount=" + this.boughtAmount + ", description='" + this.description + '\'' + ", oldPrice=" + this.oldPrice + ", iconImage='" + this.iconImage + '\'' + ", oneTimePurchasable=" + this.oneTimePurchasable + ", commands=" + this.commands + ", additionalFields=" + this.additionalFields + ", discounts=" + this.discounts + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getProductId() {
        return this.productId;
    }

    @Override
    public int getPaymentId() {
        return this.paymentId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypeRaw() {
        return this.typeRaw;
    }

    @Override
    public double getPrice() {
        return this.price;
    }

    @Override
    public long getDefaultAmount() {
        return this.defaultAmount;
    }

    @Override
    public long getBoughtAmount() {
        return this.boughtAmount;
    }

    @Override
    public String getIconImage() {
        return this.iconImage;
    }

    @Override
    public boolean isOneTimePurchasable() {
        return this.oneTimePurchasable;
    }

    @Override
    public List<String> getCommands() {
        return this.commands;
    }

    @Override
    public List<FilledAdditionalField> getAdditionalFields() {
        return this.additionalFields;
    }

    @Override
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }
}

