/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.gson.shop.mass.sale;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.mass.sale.MassSale;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.product.ProductsList;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.Implementing;
import ru.easydonate.easypayments.libs.easydonate4j.util.Wrapper;
import ru.easydonate.easypayments.libs.gson.annotations.SerializedName;

@Implementing(value=MassSale.class)
public class MassSaleModel
implements MassSale {
    @SerializedName(value="id")
    private int id;
    @SerializedName(value="shop_id")
    private Integer shopId;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="sale")
    private double discountPercent;
    @SerializedName(value="products")
    private ProductsList products;
    @SerializedName(value="starts_at")
    private LocalDateTime startsAt;
    @SerializedName(value="expires_at")
    private LocalDateTime expiresAt;
    @SerializedName(value="created_at")
    private LocalDateTime createdAt;
    @SerializedName(value="updated_at")
    private LocalDateTime updatedAt;

    @Override
    @NotNull
    public OptionalInt getShopId() {
        return Wrapper.wrapNullableInt(this.shopId);
    }

    @Override
    @NotNull
    public Optional<ProductsList> getProducts() {
        return Wrapper.wrapNullable(this.products);
    }

    @Override
    @NotNull
    public Optional<LocalDateTime> getStartsAt() {
        return Wrapper.wrapNullable(this.startsAt);
    }

    @Override
    @NotNull
    public Optional<LocalDateTime> getExpiresAt() {
        return Wrapper.wrapNullable(this.expiresAt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MassSaleModel that = (MassSaleModel)o;
        return this.id == that.id && Double.compare(that.discountPercent, this.discountPercent) == 0 && Objects.equals(this.shopId, that.shopId) && Objects.equals(this.name, that.name) && Objects.equals(this.products, that.products) && Objects.equals(this.startsAt, that.startsAt) && Objects.equals(this.expiresAt, that.expiresAt) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.updatedAt, that.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.shopId, this.name, this.discountPercent, this.products, this.startsAt, this.expiresAt, this.createdAt, this.updatedAt);
    }

    @NotNull
    public String toString() {
        return "MassSaleModel{id=" + this.id + ", shopId=" + this.shopId + ", name='" + this.name + '\'' + ", discountPercent=" + this.discountPercent + ", products=" + this.products + ", startsAt=" + this.startsAt + ", expiresAt=" + this.expiresAt + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getDiscountPercent() {
        return this.discountPercent;
    }

    @Override
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }
}

