/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.gson.shop;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.DeliveryModeType;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.Shop;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.Implementing;
import ru.easydonate.easypayments.libs.easydonate4j.util.Wrapper;
import ru.easydonate.easypayments.libs.gson.annotations.Expose;
import ru.easydonate.easypayments.libs.gson.annotations.SerializedName;

@Implementing(value=Shop.class)
public class ShopModel
implements Shop {
    @SerializedName(value="id")
    private int id;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="domain")
    private String domain;
    @SerializedName(value="last_domain")
    private String lastDomain;
    @SerializedName(value="is_active")
    private boolean active;
    @SerializedName(value="is_premium")
    private boolean premium;
    @SerializedName(value="is_verified")
    private boolean verified;
    @SerializedName(value="created_at")
    private LocalDateTime createdAt;
    @SerializedName(value="updated_at")
    private LocalDateTime updatedAt;
    @SerializedName(value="delivery_type")
    private String deliveryTypeRaw;
    @SerializedName(value="is_plugin_installed")
    private boolean pluginInstalled;
    @SerializedName(value="test_mode")
    private boolean testModeEnabled;
    @SerializedName(value="test_mode_from")
    private String whoEnabledTestMode;
    @SerializedName(value="hide_copyright")
    private boolean copyrightHidden;
    @SerializedName(value="hide_copyright_till")
    private LocalDateTime copyrightHiddenUntil;
    @SerializedName(value="pay_comission")
    private boolean paymentComissionAssignedToShop;
    @SerializedName(value="require_email")
    private boolean emailRequired;
    @SerializedName(value="use_cart")
    private boolean usesShopCart;
    @SerializedName(value="allow_nickname_spaces")
    private boolean spacesAllowedInNickNames;
    @SerializedName(value="https_redirect")
    private boolean httpsRedirectEnabled;
    @SerializedName(value="favicon")
    private String faviconImage;
    @SerializedName(value="logo")
    private String logoImage;
    @SerializedName(value="background")
    private String backgroundImage;
    @SerializedName(value="side")
    private String sideImage;
    @SerializedName(value="vk_link")
    private String vkLink;
    @SerializedName(value="youtube_link")
    private String youtubeLink;
    @SerializedName(value="discord_link")
    private String discordLink;
    @SerializedName(value="twitch_link")
    private String twitchLink;
    @SerializedName(value="instagram_link")
    private String instagramLink;
    @SerializedName(value="tiktok_link")
    private String tiktokLink;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="theme_id")
    private int themeId;
    @SerializedName(value="color")
    private String accentColor;
    @SerializedName(value="enable_background_overlay")
    private boolean usesBackgroundOverlay;
    @SerializedName(value="hide_side_image")
    private boolean sideImageHidden;
    @SerializedName(value="products_image_padding")
    private boolean productImagePaddingsEnabled;
    @SerializedName(value="hide_servers")
    private boolean serversHidden;
    @SerializedName(value="hide_general_online")
    private boolean totalOnlineHidden;
    @SerializedName(value="particles")
    private String particlesTypeRaw;
    @SerializedName(value="css")
    private String css;
    @SerializedName(value="payment_instruction")
    private String paymentInstruction;
    @SerializedName(value="hide_payment_instruction")
    private boolean paymentInstructionHidden;
    @SerializedName(value="game_id")
    private int gameId;
    @SerializedName(value="user_id")
    private int userId;
    @SerializedName(value="key")
    private String accessKey;
    @SerializedName(value="rating")
    private Double rating;
    @Expose
    private Shop.DeliveryMode cachedDeliveryMode;
    @Expose
    private Shop.TestMode cachedTestMode;
    @Expose
    private Shop.Copyright cachedCopyright;
    @Expose
    private Shop.FunctionalTab cachedFunctionalTab;
    @Expose
    private Shop.ImagesTab cachedImagesTab;
    @Expose
    private Shop.LinksTab cachedLinksTab;
    @Expose
    private Shop.CustomizationTab cachedCustomizationTab;
    @Expose
    private Shop.Extra cachedExtra;

    @Override
    @NotNull
    public Shop.DeliveryMode deliveryMode() {
        if (this.cachedDeliveryMode == null) {
            this.cachedDeliveryMode = new ProxiedDeliveryMode(this);
        }
        return this.cachedDeliveryMode;
    }

    @Override
    @NotNull
    public Shop.TestMode testMode() {
        if (this.cachedTestMode == null) {
            this.cachedTestMode = new ProxiedTestMode(this);
        }
        return this.cachedTestMode;
    }

    @Override
    @NotNull
    public Shop.Copyright copyright() {
        if (this.cachedCopyright == null) {
            this.cachedCopyright = new ProxiedCopyright(this);
        }
        return this.cachedCopyright;
    }

    @Override
    @NotNull
    public Shop.FunctionalTab functionalTab() {
        if (this.cachedFunctionalTab == null) {
            this.cachedFunctionalTab = new ProxiedFunctionalTab(this);
        }
        return this.cachedFunctionalTab;
    }

    @Override
    @NotNull
    public Shop.ImagesTab imagesTab() {
        if (this.cachedImagesTab == null) {
            this.cachedImagesTab = new ProxiedImagesTab(this);
        }
        return this.cachedImagesTab;
    }

    @Override
    @NotNull
    public Shop.LinksTab linksTab() {
        if (this.cachedLinksTab == null) {
            this.cachedLinksTab = new ProxiedLinksTab(this);
        }
        return this.cachedLinksTab;
    }

    @Override
    @NotNull
    public Shop.CustomizationTab customizationTab() {
        if (this.cachedCustomizationTab == null) {
            this.cachedCustomizationTab = new ProxiedCustomizationTab(this);
        }
        return this.cachedCustomizationTab;
    }

    @Override
    @NotNull
    public Shop.Extra extra() {
        if (this.cachedExtra == null) {
            this.cachedExtra = new ProxiedExtra(this);
        }
        return this.cachedExtra;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShopModel shopModel = (ShopModel)o;
        return this.id == shopModel.id && this.userId == shopModel.userId && this.pluginInstalled == shopModel.pluginInstalled && this.active == shopModel.active && this.premium == shopModel.premium && this.copyrightHidden == shopModel.copyrightHidden && this.verified == shopModel.verified && this.themeId == shopModel.themeId && this.usesBackgroundOverlay == shopModel.usesBackgroundOverlay && this.sideImageHidden == shopModel.sideImageHidden && this.totalOnlineHidden == shopModel.totalOnlineHidden && this.productImagePaddingsEnabled == shopModel.productImagePaddingsEnabled && this.serversHidden == shopModel.serversHidden && this.gameId == shopModel.gameId && this.testModeEnabled == shopModel.testModeEnabled && this.emailRequired == shopModel.emailRequired && this.paymentComissionAssignedToShop == shopModel.paymentComissionAssignedToShop && this.httpsRedirectEnabled == shopModel.httpsRedirectEnabled && this.spacesAllowedInNickNames == shopModel.spacesAllowedInNickNames && this.paymentInstructionHidden == shopModel.paymentInstructionHidden && this.usesShopCart == shopModel.usesShopCart && Objects.equals(this.rating, shopModel.rating) && Objects.equals(this.deliveryTypeRaw, shopModel.deliveryTypeRaw) && Objects.equals(this.name, shopModel.name) && Objects.equals(this.description, shopModel.description) && Objects.equals(this.domain, shopModel.domain) && Objects.equals(this.lastDomain, shopModel.lastDomain) && Objects.equals(this.vkLink, shopModel.vkLink) && Objects.equals(this.youtubeLink, shopModel.youtubeLink) && Objects.equals(this.discordLink, shopModel.discordLink) && Objects.equals(this.twitchLink, shopModel.twitchLink) && Objects.equals(this.instagramLink, shopModel.instagramLink) && Objects.equals(this.tiktokLink, shopModel.tiktokLink) && Objects.equals(this.accentColor, shopModel.accentColor) && Objects.equals(this.backgroundImage, shopModel.backgroundImage) && Objects.equals(this.logoImage, shopModel.logoImage) && Objects.equals(this.faviconImage, shopModel.faviconImage) && Objects.equals(this.sideImage, shopModel.sideImage) && Objects.equals(this.css, shopModel.css) && Objects.equals(this.particlesTypeRaw, shopModel.particlesTypeRaw) && Objects.equals(this.accessKey, shopModel.accessKey) && Objects.equals(this.whoEnabledTestMode, shopModel.whoEnabledTestMode) && Objects.equals(this.paymentInstruction, shopModel.paymentInstruction) && Objects.equals(this.createdAt, shopModel.createdAt) && Objects.equals(this.updatedAt, shopModel.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.userId, this.rating, this.deliveryTypeRaw, this.pluginInstalled, this.name, this.description, this.domain, this.lastDomain, this.active, this.premium, this.copyrightHidden, this.verified, this.vkLink, this.youtubeLink, this.discordLink, this.twitchLink, this.instagramLink, this.tiktokLink, this.themeId, this.accentColor, this.backgroundImage, this.logoImage, this.faviconImage, this.sideImage, this.css, this.usesBackgroundOverlay, this.sideImageHidden, this.totalOnlineHidden, this.productImagePaddingsEnabled, this.serversHidden, this.particlesTypeRaw, this.gameId, this.accessKey, this.testModeEnabled, this.whoEnabledTestMode, this.emailRequired, this.paymentComissionAssignedToShop, this.httpsRedirectEnabled, this.spacesAllowedInNickNames, this.paymentInstructionHidden, this.paymentInstruction, this.usesShopCart, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return "ShopModel{id=" + this.id + ", name='" + this.name + '\'' + ", domain='" + this.domain + '\'' + ", lastDomain='" + this.lastDomain + '\'' + ", active=" + this.active + ", premium=" + this.premium + ", verified=" + this.verified + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", deliveryTypeRaw='" + this.deliveryTypeRaw + '\'' + ", pluginInstalled=" + this.pluginInstalled + ", testModeEnabled=" + this.testModeEnabled + ", whoEnabledTestMode='" + this.whoEnabledTestMode + '\'' + ", copyrightHidden=" + this.copyrightHidden + ", copyrightHiddenUntil=" + this.copyrightHiddenUntil + ", paymentComissionAssignedToShop=" + this.paymentComissionAssignedToShop + ", emailRequired=" + this.emailRequired + ", usingShopCart=" + this.usesShopCart + ", spacesAllowedInNickNames=" + this.spacesAllowedInNickNames + ", httpsRedirectEnabled=" + this.httpsRedirectEnabled + ", faviconImage='" + this.faviconImage + '\'' + ", logoImage='" + this.logoImage + '\'' + ", backgroundImage='" + this.backgroundImage + '\'' + ", sideImage='" + this.sideImage + '\'' + ", vkLink='" + this.vkLink + '\'' + ", youtubeLink='" + this.youtubeLink + '\'' + ", discordLink='" + this.discordLink + '\'' + ", twitchLink='" + this.twitchLink + '\'' + ", instagramLink='" + this.instagramLink + '\'' + ", tiktokLink='" + this.tiktokLink + '\'' + ", description='" + this.description + '\'' + ", accentColor='" + this.accentColor + '\'' + ", themeId=" + this.themeId + ", usesBackgroundOverlay=" + this.usesBackgroundOverlay + ", sideImageHidden=" + this.sideImageHidden + ", productImagePaddingsEnabled=" + this.productImagePaddingsEnabled + ", serversHidden=" + this.serversHidden + ", totalOnlineHidden=" + this.totalOnlineHidden + ", particlesTypeRaw='" + this.particlesTypeRaw + '\'' + ", css='" + this.css + '\'' + ", paymentInstruction='" + this.paymentInstruction + '\'' + ", paymentInstructionHidden=" + this.paymentInstructionHidden + ", gameId=" + this.gameId + ", userId=" + this.userId + ", accessKey='" + this.accessKey + '\'' + ", rating=" + this.rating + '}';
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getLastDomain() {
        return this.lastDomain;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isPremium() {
        return this.premium;
    }

    @Override
    public boolean isVerified() {
        return this.verified;
    }

    @Override
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public String getDeliveryTypeRaw() {
        return this.deliveryTypeRaw;
    }

    public boolean isPluginInstalled() {
        return this.pluginInstalled;
    }

    public boolean isTestModeEnabled() {
        return this.testModeEnabled;
    }

    public String getWhoEnabledTestMode() {
        return this.whoEnabledTestMode;
    }

    public boolean isCopyrightHidden() {
        return this.copyrightHidden;
    }

    public LocalDateTime getCopyrightHiddenUntil() {
        return this.copyrightHiddenUntil;
    }

    public boolean isPaymentComissionAssignedToShop() {
        return this.paymentComissionAssignedToShop;
    }

    public boolean isEmailRequired() {
        return this.emailRequired;
    }

    public boolean isUsesShopCart() {
        return this.usesShopCart;
    }

    public boolean isSpacesAllowedInNickNames() {
        return this.spacesAllowedInNickNames;
    }

    public boolean isHttpsRedirectEnabled() {
        return this.httpsRedirectEnabled;
    }

    public String getFaviconImage() {
        return this.faviconImage;
    }

    public String getLogoImage() {
        return this.logoImage;
    }

    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    public String getSideImage() {
        return this.sideImage;
    }

    public String getVkLink() {
        return this.vkLink;
    }

    public String getYoutubeLink() {
        return this.youtubeLink;
    }

    public String getDiscordLink() {
        return this.discordLink;
    }

    public String getTwitchLink() {
        return this.twitchLink;
    }

    public String getInstagramLink() {
        return this.instagramLink;
    }

    public String getTiktokLink() {
        return this.tiktokLink;
    }

    public String getDescription() {
        return this.description;
    }

    public int getThemeId() {
        return this.themeId;
    }

    public String getAccentColor() {
        return this.accentColor;
    }

    public boolean isUsesBackgroundOverlay() {
        return this.usesBackgroundOverlay;
    }

    public boolean isSideImageHidden() {
        return this.sideImageHidden;
    }

    public boolean isProductImagePaddingsEnabled() {
        return this.productImagePaddingsEnabled;
    }

    public boolean isServersHidden() {
        return this.serversHidden;
    }

    public boolean isTotalOnlineHidden() {
        return this.totalOnlineHidden;
    }

    public String getParticlesTypeRaw() {
        return this.particlesTypeRaw;
    }

    public String getCss() {
        return this.css;
    }

    public String getPaymentInstruction() {
        return this.paymentInstruction;
    }

    public boolean isPaymentInstructionHidden() {
        return this.paymentInstructionHidden;
    }

    public int getGameId() {
        return this.gameId;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public Double getRating() {
        return this.rating;
    }

    public Shop.DeliveryMode getCachedDeliveryMode() {
        return this.cachedDeliveryMode;
    }

    public Shop.TestMode getCachedTestMode() {
        return this.cachedTestMode;
    }

    public Shop.Copyright getCachedCopyright() {
        return this.cachedCopyright;
    }

    public Shop.FunctionalTab getCachedFunctionalTab() {
        return this.cachedFunctionalTab;
    }

    public Shop.ImagesTab getCachedImagesTab() {
        return this.cachedImagesTab;
    }

    public Shop.LinksTab getCachedLinksTab() {
        return this.cachedLinksTab;
    }

    public Shop.CustomizationTab getCachedCustomizationTab() {
        return this.cachedCustomizationTab;
    }

    public Shop.Extra getCachedExtra() {
        return this.cachedExtra;
    }

    private static final class ProxiedExtra
    implements Shop.Extra {
        private final ShopModel shop;

        @Override
        public int getGameId() {
            return this.shop.gameId;
        }

        @Override
        public int getUserId() {
            return this.shop.userId;
        }

        @Override
        @NotNull
        public String getAccessKey() {
            return this.shop.accessKey;
        }

        @Override
        @NotNull
        public OptionalDouble getRating() {
            return Wrapper.wrapNullableDouble(this.shop.rating);
        }

        @Override
        @Nullable
        public Double getRatingRaw() {
            return this.shop.rating;
        }

        private ProxiedExtra(ShopModel shop) {
            this.shop = shop;
        }
    }

    private static final class ProxiedCustomizationTab
    implements Shop.CustomizationTab {
        private final ShopModel shop;

        @Override
        @NotNull
        public Optional<String> getDescription() {
            return Wrapper.wrapNullable(this.shop.description);
        }

        @Override
        @NotNull
        public String getAccentColor() {
            return this.shop.accentColor;
        }

        @Override
        public int getThemeId() {
            return this.shop.themeId;
        }

        @Override
        public boolean isUsesBackgroundOverlay() {
            return this.shop.usesBackgroundOverlay;
        }

        @Override
        public boolean isSideImageHidden() {
            return this.shop.sideImageHidden;
        }

        @Override
        public boolean isProductImagePaddingsEnabled() {
            return this.shop.productImagePaddingsEnabled;
        }

        @Override
        public boolean isServersHidden() {
            return this.shop.serversHidden;
        }

        @Override
        public boolean isTotalOnlineHidden() {
            return this.shop.totalOnlineHidden;
        }

        @Override
        @NotNull
        public Shop.ParticlesType getParticlesType() {
            return Shop.ParticlesType.getByKey(this.shop.particlesTypeRaw);
        }

        @Override
        @NotNull
        public String getParticlesTypeRaw() {
            return this.shop.particlesTypeRaw;
        }

        @Override
        @NotNull
        public Optional<String> getCustomCSS() {
            return Wrapper.wrapNullable(this.shop.css);
        }

        @Override
        @NotNull
        public String getPaymentInstruction() {
            return this.shop.paymentInstruction;
        }

        @Override
        public boolean isPaymentInstructionHidden() {
            return this.shop.paymentInstructionHidden;
        }

        private ProxiedCustomizationTab(ShopModel shop) {
            this.shop = shop;
        }
    }

    private static final class ProxiedLinksTab
    implements Shop.LinksTab {
        private final ShopModel shop;

        @Override
        @NotNull
        public Optional<String> getVKontakteLink() {
            return Wrapper.wrapNullable(this.shop.vkLink);
        }

        @Override
        @NotNull
        public Optional<String> getYouTubeLink() {
            return Wrapper.wrapNullable(this.shop.youtubeLink);
        }

        @Override
        @NotNull
        public Optional<String> getDiscordLink() {
            return Wrapper.wrapNullable(this.shop.discordLink);
        }

        @Override
        @NotNull
        public Optional<String> getTwitchLink() {
            return Wrapper.wrapNullable(this.shop.twitchLink);
        }

        @Override
        @NotNull
        public Optional<String> getInstagramLink() {
            return Wrapper.wrapNullable(this.shop.instagramLink);
        }

        @Override
        @NotNull
        public Optional<String> getTikTokLink() {
            return Wrapper.wrapNullable(this.shop.tiktokLink);
        }

        private ProxiedLinksTab(ShopModel shop) {
            this.shop = shop;
        }
    }

    private static final class ProxiedImagesTab
    implements Shop.ImagesTab {
        private final ShopModel shop;

        @Override
        @NotNull
        public Optional<String> getFaviconImage() {
            return Wrapper.wrapNullable(this.shop.faviconImage);
        }

        @Override
        @NotNull
        public Optional<String> getLogoImage() {
            return Wrapper.wrapNullable(this.shop.logoImage);
        }

        @Override
        @NotNull
        public Optional<String> getBackgroundImage() {
            return Wrapper.wrapNullable(this.shop.backgroundImage);
        }

        @Override
        @NotNull
        public Optional<String> getSideImage() {
            return Wrapper.wrapNullable(this.shop.sideImage);
        }

        private ProxiedImagesTab(ShopModel shop) {
            this.shop = shop;
        }
    }

    private static final class ProxiedFunctionalTab
    implements Shop.FunctionalTab {
        private final ShopModel shop;

        @Override
        public boolean isPaymentComissionAssignedToShop() {
            return this.shop.paymentComissionAssignedToShop;
        }

        @Override
        public boolean isEmailRequired() {
            return this.shop.emailRequired;
        }

        @Override
        public boolean isUsesShopCart() {
            return this.shop.usesShopCart;
        }

        @Override
        public boolean isSpacesAllowedInNickNames() {
            return this.shop.spacesAllowedInNickNames;
        }

        @Override
        public boolean isHttpsRedirectEnabled() {
            return this.shop.httpsRedirectEnabled;
        }

        private ProxiedFunctionalTab(ShopModel shop) {
            this.shop = shop;
        }
    }

    private static final class ProxiedCopyright
    implements Shop.Copyright {
        private final ShopModel shop;

        @Override
        public boolean isHidden() {
            return this.shop.copyrightHidden;
        }

        @Override
        @NotNull
        public Optional<LocalDateTime> getHiddenUntil() {
            return Wrapper.wrapNullable(this.shop.copyrightHiddenUntil);
        }

        private ProxiedCopyright(ShopModel shop) {
            this.shop = shop;
        }
    }

    private static final class ProxiedTestMode
    implements Shop.TestMode {
        private final ShopModel shop;

        @Override
        public boolean isEnabled() {
            return this.shop.testModeEnabled;
        }

        @Override
        @NotNull
        public Optional<String> getWhoEnabled() {
            return Wrapper.wrapNullable(this.shop.whoEnabledTestMode);
        }

        private ProxiedTestMode(ShopModel shop) {
            this.shop = shop;
        }
    }

    private static final class ProxiedDeliveryMode
    implements Shop.DeliveryMode {
        private final ShopModel shop;

        @Override
        @NotNull
        public DeliveryModeType getType() {
            return DeliveryModeType.getByKey(this.shop.deliveryTypeRaw);
        }

        @Override
        @NotNull
        public String getTypeRaw() {
            return this.shop.deliveryTypeRaw;
        }

        @Override
        public boolean isPluginInstalled() {
            return this.shop.pluginInstalled;
        }

        private ProxiedDeliveryMode(ShopModel shop) {
            this.shop = shop;
        }
    }
}

