/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.gson.plugin.easydonate.surcharge;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.gson.shop.AdditionalFieldModel;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.easydonate.surcharge.SurchargeDiscount;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.AdditionalField;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.ProductType;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.Implementing;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.deserializer.gson.NonNullListDeserializer;
import ru.easydonate.easypayments.libs.easydonate4j.util.Wrapper;
import ru.easydonate.easypayments.libs.gson.annotations.JsonAdapter;
import ru.easydonate.easypayments.libs.gson.annotations.SerializedName;

@Implementing(value=SurchargeDiscount.class)
public class SurchargeDiscountModel
implements SurchargeDiscount {
    @SerializedName(value="id")
    private int id;
    @SerializedName(value="shop_id")
    private int shopId;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="type")
    private String typeRaw;
    @SerializedName(value="price")
    private double price;
    @SerializedName(value="number")
    private int amount;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="old_price")
    private Double oldPrice;
    @SerializedName(value="category_id")
    private Integer categoryId;
    @SerializedName(value="image")
    private String iconImage;
    @SerializedName(value="is_hidden")
    private boolean hidden;
    @SerializedName(value="first_delete")
    private boolean oneTimePurchasable;
    @SerializedName(value="commands")
    private List<String> commands;
    @SerializedName(value="withdraw_commands")
    @JsonAdapter(value=NonNullListDeserializer.class)
    private List<String> withdrawCommands;
    @SerializedName(value="withdraw_commands_days")
    private Integer withdrawCommandsDelay;
    @SerializedName(value="additional_fields")
    @JsonAdapter(value=AdditionalFieldModel.ListDeserializer.class)
    private List<AdditionalField> additionalFields;
    @SerializedName(value="sort_index")
    private int sortIndex;
    @SerializedName(value="discount")
    private double discountAmount;
    @SerializedName(value="target")
    private ExtraData currentMostExpensive;
    @SerializedName(value="created_at")
    private LocalDateTime createdAt;
    @SerializedName(value="updated_at")
    private LocalDateTime updatedAt;

    @Override
    @NotNull
    public ProductType getType() {
        return ProductType.getByKey(this.typeRaw);
    }

    @Override
    @NotNull
    public Optional<String> getDescription() {
        return Wrapper.wrapNullable(this.description);
    }

    @Override
    @NotNull
    public OptionalDouble getOldPrice() {
        return Wrapper.wrapNullableDouble(this.oldPrice);
    }

    @Override
    @NotNull
    public OptionalInt getCategoryId() {
        return Wrapper.wrapNullableInt(this.categoryId);
    }

    @Override
    @NotNull
    public OptionalInt getWithdrawCommandsDelay() {
        return Wrapper.wrapNullableInt(this.withdrawCommandsDelay);
    }

    @Override
    @NotNull
    public OptionalInt getCurrentMostExpensiveId() {
        if (this.currentMostExpensive != null) {
            return OptionalInt.of(this.currentMostExpensive.getId());
        }
        return OptionalInt.empty();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getShopId() {
        return this.shopId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypeRaw() {
        return this.typeRaw;
    }

    @Override
    public double getPrice() {
        return this.price;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public String getIconImage() {
        return this.iconImage;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isOneTimePurchasable() {
        return this.oneTimePurchasable;
    }

    @Override
    public List<String> getCommands() {
        return this.commands;
    }

    @Override
    public List<String> getWithdrawCommands() {
        return this.withdrawCommands;
    }

    public List<AdditionalField> getAdditionalFields() {
        return this.additionalFields;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    @Override
    public double getDiscountAmount() {
        return this.discountAmount;
    }

    public ExtraData getCurrentMostExpensive() {
        return this.currentMostExpensive;
    }

    @Override
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public static final class ExtraData {
        @SerializedName(value="id")
        private int id;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtraData target = (ExtraData)o;
            return this.id == target.id;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        @NotNull
        public String toString() {
            return "Target{id=" + this.id + '}';
        }

        public int getId() {
            return this.id;
        }
    }
}

