/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.api.v3.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.client.SimpleEasyDonateClient;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.PluginManager;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.ActivityFlag;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.Shop;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.coupon.CouponsList;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.mass.sale.MassSalesList;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.payment.Payment;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.payment.PaymentsList;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.payment.pending.PendingPayment;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.payment.pending.PendingPaymentBuilder;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.product.Product;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.product.ProductsList;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.server.Server;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.server.ServersList;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.ApiResponse;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpRequestException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpResponseException;
import ru.easydonate.easypayments.libs.easydonate4j.http.client.HttpClient;
import ru.easydonate.easypayments.libs.easydonate4j.http.request.EasyHttpRequest;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.JsonSerializationService;

public interface EasyDonateClient {
    @NotNull
    public static EasyDonateClient create(@NotNull String accessKey) {
        return EasyDonateClient.create(accessKey, "EasyDonate4J", 5000L, 5000L, 5000L);
    }

    @NotNull
    public static EasyDonateClient create(@NotNull String accessKey, @NotNull String userAgent) {
        return EasyDonateClient.create(accessKey, "EasyDonate4J", 5000L, 5000L, 5000L);
    }

    @NotNull
    public static EasyDonateClient create(@NotNull String accessKey, long connectTimeout, long readTimeout, long writeTimeout) {
        return EasyDonateClient.create(accessKey, "EasyDonate4J", connectTimeout, readTimeout, writeTimeout);
    }

    @NotNull
    public static EasyDonateClient create(@NotNull String accessKey, @NotNull String userAgent, long connectTimeout, long readTimeout, long writeTimeout) {
        return EasyDonateClient.builder().setAccessKey(accessKey).setConnectTimeout(connectTimeout, TimeUnit.MILLISECONDS).setReadTimeout(readTimeout, TimeUnit.MILLISECONDS).setWriteTimeout(writeTimeout, TimeUnit.MILLISECONDS).setUserAgent(userAgent).create();
    }

    @NotNull
    public static Builder builder() {
        return new SimpleEasyDonateClient.SimpleBuilder();
    }

    @NotNull
    public String getAccessKey();

    @NotNull
    public HttpClient getHttpClient();

    @NotNull
    public JsonSerializationService getJsonSerialization();

    @NotNull
    public Shop getShop() throws HttpRequestException, HttpResponseException;

    @NotNull
    public Product getProduct(int var1) throws HttpRequestException, HttpResponseException;

    @NotNull
    public ProductsList getProductsList() throws HttpRequestException, HttpResponseException;

    @NotNull
    public Server getServer(int var1) throws HttpRequestException, HttpResponseException;

    @NotNull
    public ServersList getServersList() throws HttpRequestException, HttpResponseException;

    @NotNull
    public MassSalesList getMassSalesList() throws HttpRequestException, HttpResponseException;

    @NotNull
    public MassSalesList getMassSalesList(@NotNull ActivityFlag var1) throws HttpRequestException, HttpResponseException;

    @NotNull
    public CouponsList getCouponsList() throws HttpRequestException, HttpResponseException;

    @NotNull
    public CouponsList getCouponsList(@NotNull ActivityFlag var1) throws HttpRequestException, HttpResponseException;

    @NotNull
    public Payment getPayment(int var1) throws HttpRequestException, HttpResponseException;

    @NotNull
    public PaymentsList getPaymentsList() throws HttpRequestException, HttpResponseException;

    @NotNull
    public PendingPaymentBuilder createPayment();

    @NotNull
    public PendingPayment createPayment(@NotNull PendingPaymentBuilder var1) throws HttpRequestException, HttpResponseException;

    @NotNull
    public PluginManager getPluginManager();

    @NotNull
    public <T> T request(@NotNull Class<? extends ApiResponse<T>> var1, @NotNull EasyHttpRequest var2) throws HttpRequestException, HttpResponseException;

    @NotNull
    public <T> CompletableFuture<T> requestAsync(@NotNull Class<? extends ApiResponse<T>> var1, @NotNull EasyHttpRequest var2);

    @NotNull
    public EasyHttpRequest.Builder createRequest(@NotNull HttpClient.Method var1);

    public static interface Builder {
        @NotNull
        public EasyDonateClient create();

        @NotNull
        public Builder setAccessKey(@NotNull String var1);

        @NotNull
        public Builder setConnectTimeout(long var1, @NotNull TimeUnit var3);

        @NotNull
        public Builder setResponseTimeout(long var1, @NotNull TimeUnit var3);

        @NotNull
        public Builder setReadTimeout(long var1, @NotNull TimeUnit var3);

        @NotNull
        public Builder setWriteTimeout(long var1, @NotNull TimeUnit var3);

        @NotNull
        public Builder setUserAgent(@NotNull String var1);
    }
}

