/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.database.persister;

import java.lang.reflect.Type;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.libs.gson.Gson;
import ru.easydonate.easypayments.libs.gson.GsonBuilder;
import ru.easydonate.easypayments.libs.gson.JsonParseException;
import ru.easydonate.easypayments.libs.gson.JsonSyntaxException;
import ru.easydonate.easypayments.libs.gson.internal.$Gson$Types;
import ru.easydonate.easypayments.libs.ormlite.field.FieldType;
import ru.easydonate.easypayments.libs.ormlite.field.SqlType;
import ru.easydonate.easypayments.libs.ormlite.field.types.LongStringType;

public final class JsonArrayPersister
extends LongStringType {
    private static final JsonArrayPersister SINGLETON = new JsonArrayPersister();
    private final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private final Type genericType = $Gson$Types.newParameterizedTypeWithOwner(null, List.class, new Type[]{String.class});

    private JsonArrayPersister() {
        super(SqlType.LONG_STRING, new Class[]{List.class});
    }

    @NotNull
    public static JsonArrayPersister getSingleton() {
        return SINGLETON;
    }

    @Override
    @Nullable
    public String javaToSqlArg(@NotNull FieldType fieldType, @Nullable Object javaObject) {
        try {
            if (javaObject instanceof List) {
                List asList = (List)javaObject;
                return this.gson.toJson(asList);
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> sqlArgToJava(@NotNull FieldType fieldType, @Nullable Object sqlArg, int columnPos) {
        try {
            if (sqlArg instanceof String) {
                String asString = (String)sqlArg;
                return (List)this.gson.fromJson(asString, this.genericType);
            }
        }
        catch (JsonParseException jsonParseException) {
            // empty catch block
        }
        return null;
    }
}

