/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.database.credentials.local;

import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.database.DatabaseType;
import ru.easydonate.easypayments.database.credentials.local.AbstractLocalDatabaseCredentials;
import ru.easydonate.easypayments.exception.DriverLoadException;
import ru.easydonate.easypayments.exception.DriverNotFoundException;

public final class H2DatabaseCredentials
extends AbstractLocalDatabaseCredentials {
    public static final String DRIVER_DOWNLOAD_URL = "https://repo1.maven.org/maven2/com/h2database/h2/2.1.210/h2-2.1.210.jar";
    public static final String DRIVER_FILE_CHECKSUM = "af4adae008b4f91819f078c55dbef025";
    public static final String DRIVER_OUTPUT_FILE = "h2.jar";
    public static final String DRIVER_CLASS = "org.h2.Driver";
    public static final String URL_PATTERN = "jdbc:h2:%s%s";

    public H2DatabaseCredentials(@NotNull Plugin plugin) {
        super(plugin, DatabaseType.H2);
    }

    @Override
    @NotNull
    public String getConnectionUrl() {
        return String.format(URL_PATTERN, this.getFilePath(), this.formatParameters());
    }

    @Override
    public void loadDriver(@NotNull Plugin plugin) throws DriverNotFoundException, DriverLoadException {
        this.checkDriver(plugin, true);
    }

    @Override
    @NotNull
    protected String getDriverDownloadURL() {
        return DRIVER_DOWNLOAD_URL;
    }

    @Override
    @NotNull
    protected String getDriverFileChecksum() {
        return DRIVER_FILE_CHECKSUM;
    }

    @Override
    @NotNull
    protected String getDriverOutputFile() {
        return DRIVER_OUTPUT_FILE;
    }

    @Override
    protected void checkDriver(@NotNull Plugin plugin, boolean tryDownloadDriver) throws DriverNotFoundException, DriverLoadException {
        try {
            this.checkDriver(plugin, DRIVER_CLASS);
            if (tryDownloadDriver) {
                plugin.getLogger().info("H2 JDBC Driver is already loaded in the JVM Runtime.");
            }
        }
        catch (DriverNotFoundException ex) {
            if (tryDownloadDriver) {
                this.tryDownloadDriver(plugin);
            }
            throw ex;
        }
    }
}

