/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.database.credentials.local;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.commons.lang.Validate;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.database.DatabaseType;
import ru.easydonate.easypayments.database.credentials.AbstractDatabaseCredentials;
import ru.easydonate.easypayments.database.credentials.CredentialField;
import ru.easydonate.easypayments.database.credentials.local.LocalDatabaseCredentials;
import ru.easydonate.easypayments.libs.ormlite.jdbc.JdbcConnectionSource;
import ru.easydonate.easypayments.libs.ormlite.support.ConnectionSource;

public abstract class AbstractLocalDatabaseCredentials
extends AbstractDatabaseCredentials
implements LocalDatabaseCredentials {
    protected final Plugin plugin;
    @CredentialField(value="file")
    protected String filePath;

    protected AbstractLocalDatabaseCredentials(@NotNull Plugin plugin, @NotNull DatabaseType databaseType) {
        super(databaseType);
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public String getFilePath() {
        Validate.notEmpty((String)this.filePath, (String)"filePath");
        return this.plugin.getDataFolder().toPath().resolve(this.filePath).toAbsolutePath().toString();
    }

    @Override
    @NotNull
    public ConnectionSource getConnectionSource() throws SQLException {
        return new JdbcConnectionSource(this.getConnectionUrl());
    }

    @Generated
    public Plugin getPlugin() {
        return this.plugin;
    }
}

