/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.database.credentials;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.util.Reflection;
import ru.easydonate.easypayments.database.DatabaseType;
import ru.easydonate.easypayments.database.credentials.CredentialField;
import ru.easydonate.easypayments.database.credentials.DatabaseCredentials;
import ru.easydonate.easypayments.exception.CredentialsParseException;

public final class DatabaseCredentialsParser {
    public static <T extends DatabaseCredentials> T parse(@NotNull Plugin plugin, @NotNull ConfigurationSection config, @NotNull DatabaseType databaseType) throws CredentialsParseException {
        DatabaseCredentials credentials;
        Class<? extends DatabaseCredentials> providingClass = databaseType.getProvidingClass();
        try {
            Constructor<? extends DatabaseCredentials> constructor = providingClass.getConstructor(Plugin.class);
            credentials = constructor.newInstance(plugin);
        }
        catch (NoSuchMethodException ignored) {
            try {
                Constructor<? extends DatabaseCredentials> constructor = providingClass.getConstructor(new Class[0]);
                credentials = constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new CredentialsParseException("A valid constructor was not found in " + providingClass.getName() + "!", databaseType);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new CredentialsParseException("Cannot invoke constructor in " + providingClass.getName() + "!", ex, databaseType);
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new CredentialsParseException("Cannot invoke constructor in " + providingClass.getName() + "!", ex, databaseType);
        }
        Map keys = config.getValues(false);
        Map<Field, CredentialField> fields = Reflection.findAnnotatedDeclaredFields(providingClass, CredentialField.class);
        if (!fields.isEmpty()) {
            for (Field field : fields.keySet()) {
                CredentialField annotation = fields.get(field);
                String fieldName = field.getName();
                String configField = annotation.value();
                if (configField == null) continue;
                Object configValue = keys.get(configField);
                if (configValue == null) {
                    if (annotation.optional()) continue;
                    throw new CredentialsParseException("A required credentials field '" + fieldName + "' isn't specified in your config!", databaseType);
                }
                try {
                    field.setAccessible(true);
                }
                catch (SecurityException ex) {
                    throw new CredentialsParseException("Couldn't make field '" + fieldName + "' accessible!", databaseType);
                }
                try {
                    field.set(credentials, configValue);
                }
                catch (IllegalAccessException ex) {
                    throw new CredentialsParseException("Couldn't modify value of field '" + fieldName + "'!", databaseType);
                }
            }
        }
        return (T)credentials;
    }
}

