/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.database.credentials;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.dependency.DependencyLoader;
import ru.easydonate.easypayments.core.dependency.PluginDependencyLoader;
import ru.easydonate.easypayments.core.util.ChecksumSupplier;
import ru.easydonate.easypayments.database.DatabaseType;
import ru.easydonate.easypayments.database.credentials.CredentialField;
import ru.easydonate.easypayments.database.credentials.DatabaseCredentials;
import ru.easydonate.easypayments.exception.DriverLoadException;
import ru.easydonate.easypayments.exception.DriverNotFoundException;

public abstract class AbstractDatabaseCredentials
implements DatabaseCredentials {
    @NotNull
    protected final DatabaseType databaseType;
    @CredentialField(value="params", optional=true)
    protected List<String> parameters;

    protected String formatParameters() {
        if (this.parameters == null || this.parameters.isEmpty()) {
            return "";
        }
        String joined = this.parameters.stream().map(this::urlEncode).collect(Collectors.joining("&"));
        return "?" + joined;
    }

    @NotNull
    protected String getDriverDownloadURL() {
        throw new UnsupportedOperationException("Not implemented by this credentials implementation!");
    }

    @NotNull
    protected String getDriverFileChecksum() {
        throw new UnsupportedOperationException("Not implemented by this credentials implementation!");
    }

    @NotNull
    protected String getDriverOutputFile() {
        throw new UnsupportedOperationException("Not implemented by this credentials implementation!");
    }

    protected void checkDriver(@NotNull Plugin plugin, boolean tryDownloadDriver) throws DriverNotFoundException, DriverLoadException {
        throw new UnsupportedOperationException("Not implemented by this credentials implementation!");
    }

    protected void checkDriver(@NotNull Plugin plugin, @NotNull String driverClass) throws DriverNotFoundException {
        try {
            Constructor<?> constructor = Class.forName(driverClass).getConstructor(new Class[0]);
            constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new DriverNotFoundException(ex, this.databaseType);
        }
    }

    protected void tryDownloadDriver(@NotNull Plugin plugin) throws DriverNotFoundException, DriverLoadException {
        boolean loaded;
        DependencyLoader dependencyLoader = PluginDependencyLoader.forPlugin(plugin);
        try {
            Path driverFile = this.downloadDriver(plugin);
            loaded = dependencyLoader.load(driverFile);
            if (loaded) {
                this.checkDriver(plugin, false);
                plugin.getLogger().info(this.databaseType.getName() + " JDBC Driver has been loaded into the JVM Runtime.");
            }
        }
        catch (DriverLoadException | DriverNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new DriverLoadException(ex, this.databaseType);
        }
        catch (Exception ex) {
            throw new DriverNotFoundException(ex, this.databaseType);
        }
        if (!loaded) {
            throw new DriverLoadException("Couldn't download the " + this.databaseType.getName() + " JDBC Driver!", this.databaseType);
        }
    }

    @NotNull
    protected Path downloadDriver(@NotNull Plugin plugin) throws IOException, DriverLoadException {
        Path driverDir = plugin.getDataFolder().toPath().resolve("driver");
        if (!Files.isDirectory(driverDir, new LinkOption[0])) {
            Files.createDirectories(driverDir, new FileAttribute[0]);
        }
        DatabaseType databaseType = this.getDatabaseType();
        String driverDownloadURL = this.getDriverDownloadURL();
        String driverOutputFile = this.getDriverOutputFile();
        Path destPath = driverDir.resolve(driverOutputFile);
        if (Files.isRegularFile(destPath, new LinkOption[0])) {
            if (!this.verifyMD5Hashsum(destPath)) {
                throw new DriverLoadException("Failed to verify MD5 checksum! Please, try again.", databaseType);
            }
            return destPath;
        }
        Files.delete(destPath);
        InputStream externalResource = new URL(driverDownloadURL).openConnection().getInputStream();
        if (externalResource == null) {
            throw new DriverLoadException("External driver resource was not found!", databaseType);
        }
        plugin.getLogger().info("Downloading " + databaseType.getName() + " JDBC driver...");
        plugin.getLogger().info("URL: " + driverDownloadURL);
        Files.copy(externalResource, destPath, StandardCopyOption.REPLACE_EXISTING);
        return destPath;
    }

    private boolean verifyMD5Hashsum(@NotNull Path downloadedFile) {
        try {
            String checksum = ChecksumSupplier.getChecksumAsString(downloadedFile);
            return checksum.equalsIgnoreCase(this.getDriverFileChecksum());
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private String urlEncode(String source) {
        return URLEncoder.encode(source, "UTF-8");
    }

    @Override
    @NotNull
    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public List<String> getParameters() {
        return this.parameters;
    }

    @Generated
    protected AbstractDatabaseCredentials(@NotNull DatabaseType databaseType) {
        if (databaseType == null) {
            throw new NullPointerException("databaseType is marked non-null but is null");
        }
        this.databaseType = databaseType;
    }
}

