/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.database;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.database.credentials.DatabaseCredentials;
import ru.easydonate.easypayments.database.credentials.local.H2DatabaseCredentials;
import ru.easydonate.easypayments.database.credentials.local.SQLiteDatabaseCredentials;
import ru.easydonate.easypayments.database.credentials.remote.MySQLDatabaseCredentials;
import ru.easydonate.easypayments.database.credentials.remote.PostgreSQLDatabaseCredentials;

public enum DatabaseType {
    MYSQL("mysql", "MySQL", MySQLDatabaseCredentials.class),
    SQLITE("sqlite", "SQLite", SQLiteDatabaseCredentials.class),
    H2("h2", "H2", H2DatabaseCredentials.class),
    POSTGRESQL("postgresql", "PostgreSQL", PostgreSQLDatabaseCredentials.class),
    UNKNOWN("unknown", "Unknown", null);

    private final String key;
    private final String name;
    private final Class<? extends DatabaseCredentials> providingClass;

    @NotNull
    public static DatabaseType getByKey(@Nullable String key) {
        if (key != null && !key.isEmpty()) {
            for (DatabaseType databaseType : DatabaseType.values()) {
                if (!databaseType.getKey().equalsIgnoreCase(key)) continue;
                return databaseType;
            }
        }
        return UNKNOWN;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Class<? extends DatabaseCredentials> getProvidingClass() {
        return this.providingClass;
    }

    @Generated
    private DatabaseType(String key, String name, Class<? extends DatabaseCredentials> providingClass) {
        this.key = key;
        this.name = name;
        this.providingClass = providingClass;
    }
}

