/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.database;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import lombok.Generated;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.core.EasyPayments;
import ru.easydonate.easypayments.core.config.Configuration;
import ru.easydonate.easypayments.database.Database;
import ru.easydonate.easypayments.database.DatabaseType;
import ru.easydonate.easypayments.database.model.Customer;
import ru.easydonate.easypayments.database.model.Payment;
import ru.easydonate.easypayments.database.model.Purchase;
import ru.easydonate.easypayments.libs.ormlite.dao.Dao;
import ru.easydonate.easypayments.libs.ormlite.dao.DaoManager;
import ru.easydonate.easypayments.libs.ormlite.support.ConnectionSource;

public final class DatabaseManager {
    private final EasyPayments plugin;
    private final Configuration config;
    private final Database database;
    private final ConnectionSource connectionSource;
    private final ExecutorService asyncExecutorService;
    private final Dao<Customer, String> customersDao;
    private final Dao<Payment, Integer> paymentsDao;
    private final Dao<Purchase, Integer> purchasesDao;

    public DatabaseManager(@NotNull EasyPayments plugin, @NotNull Configuration config, @NotNull Database database) throws SQLException {
        this.plugin = plugin;
        this.config = config;
        this.database = database;
        this.connectionSource = database.establishConnection();
        this.asyncExecutorService = Executors.newCachedThreadPool();
        this.customersDao = DaoManager.createDao(this.connectionSource, Customer.class);
        this.paymentsDao = DaoManager.createDao(this.connectionSource, Payment.class);
        this.purchasesDao = DaoManager.createDao(this.connectionSource, Purchase.class);
    }

    public void shutdown() {
        if (this.asyncExecutorService != null) {
            this.asyncExecutorService.shutdown();
        }
        if (this.connectionSource != null) {
            this.connectionSource.closeQuietly();
        }
    }

    @NotNull
    public DatabaseType getDatabaseType() {
        return this.database.getDatabaseType();
    }

    @NotNull
    public CompletableFuture<Integer> transferCustomersDataFrom(@NotNull DatabaseManager sourceStorage) {
        return this.transferDataFrom(sourceStorage, DatabaseManager::getCustomersDao);
    }

    @NotNull
    public CompletableFuture<Integer> transferPaymentsDataFrom(@NotNull DatabaseManager sourceStorage) {
        return this.transferDataFrom(sourceStorage, DatabaseManager::getPaymentsDao);
    }

    @NotNull
    public CompletableFuture<Integer> transferPurchasesDataFrom(@NotNull DatabaseManager sourceStorage) {
        return this.transferDataFrom(sourceStorage, DatabaseManager::getPurchasesDao);
    }

    @NotNull
    private <T, ID> CompletableFuture<Integer> transferDataFrom(@NotNull DatabaseManager sourceStorage, @NotNull Function<DatabaseManager, Dao<T, ID>> daoExtractor) {
        return this.supplyAsync(() -> {
            Dao sourceDao = (Dao)daoExtractor.apply(sourceStorage);
            Dao destinationDao = (Dao)daoExtractor.apply(this);
            List entries = sourceDao.queryForAll();
            for (Object entry : entries) {
                destinationDao.createIfNotExists(entry);
            }
            return entries.size();
        });
    }

    @NotNull
    public CompletableFuture<Customer> getCustomerByName(@NotNull String playerName) {
        return this.supplyAsync(() -> this.customersDao.queryForId(playerName));
    }

    @NotNull
    public CompletableFuture<Customer> getCustomerByUUID(@NotNull UUID playerUUID) {
        return this.supplyAsync(() -> (Customer)this.customersDao.queryBuilder().where().eq("player_uuid", playerUUID).queryForFirst());
    }

    @NotNull
    public CompletableFuture<Customer> getCustomer(@NotNull OfflinePlayer bukkitPlayer) {
        if (this.isUuidIdentificationEnabled()) {
            return this.getCustomerByName(bukkitPlayer.getName());
        }
        return this.getCustomerByUUID(bukkitPlayer.getUniqueId());
    }

    @NotNull
    public CompletableFuture<Customer> getOrCreateCustomer(@NotNull OfflinePlayer bukkitPlayer) {
        return this.getOrCreateCustomer(bukkitPlayer, bukkitPlayer.getName());
    }

    @NotNull
    public CompletableFuture<Customer> getOrCreateCustomer(@NotNull OfflinePlayer bukkitPlayer, @NotNull String playerName) {
        return this.getCustomerByName(playerName).thenApply(customer -> {
            if (customer == null) {
                customer = new Customer(playerName, bukkitPlayer.getUniqueId());
                this.saveCustomer((Customer)customer).join();
            }
            return customer;
        });
    }

    @NotNull
    public CompletableFuture<Void> transferCustomerOwnership(@NotNull Customer customer, @NotNull String playerName) {
        return this.runAsync(() -> this.customersDao.updateId(customer, playerName));
    }

    @NotNull
    public CompletableFuture<Void> refreshCustomer(@NotNull Customer customer) {
        return this.runAsync(() -> this.customersDao.refresh(customer));
    }

    @NotNull
    public CompletableFuture<Void> saveCustomer(@NotNull Customer customer) {
        return this.runAsync(() -> this.customersDao.createOrUpdate(customer));
    }

    @NotNull
    public CompletableFuture<List<Payment>> getAllUnreportedPayments(int serverId) {
        return this.supplyAsync(() -> this.paymentsDao.queryBuilder().where().eq("server_id", serverId).and().isNull("reported_at").query());
    }

    @NotNull
    public CompletableFuture<Payment> getPayment(int paymentId) {
        return this.supplyAsync(() -> this.paymentsDao.queryForId(paymentId));
    }

    @NotNull
    public CompletableFuture<Void> refreshPayment(@NotNull Payment payment) {
        return this.runAsync(() -> this.paymentsDao.refresh(payment));
    }

    @NotNull
    public CompletableFuture<Void> savePayment(@NotNull Payment payment) {
        return this.runAsync(() -> this.paymentsDao.createOrUpdate(payment));
    }

    @NotNull
    public CompletableFuture<Purchase> getPurchase(int purchaseId) {
        return this.supplyAsync(() -> this.purchasesDao.queryForId(purchaseId));
    }

    @NotNull
    public CompletableFuture<Void> savePurchase(@NotNull Purchase purchase) {
        return this.runAsync(() -> this.purchasesDao.createOrUpdate(purchase));
    }

    @NotNull
    private CompletableFuture<Void> runAsync(@NotNull ThrowableRunnable task) {
        return CompletableFuture.runAsync(() -> {
            try {
                task.run();
            }
            catch (SQLException ex) {
                this.handleThrowable(ex);
            }
        }, this.asyncExecutorService);
    }

    @NotNull
    private <T> CompletableFuture<T> supplyAsync(@NotNull ThrowableSupplier<T> task) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return task.supply();
            }
            catch (SQLException ex) {
                this.handleThrowable(ex);
                return null;
            }
        }, this.asyncExecutorService);
    }

    private void handleThrowable(@NotNull Throwable throwable) {
        this.plugin.getLogger().severe("An error has occurred when this plugin tried to handle an SQL statement!");
        this.plugin.getDebugLogger().error("An error has occurred when this plugin tried to handle an SQL statement!", new Object[0]);
        this.plugin.getDebugLogger().error(throwable);
    }

    public boolean isUuidIdentificationEnabled() {
        return this.config.getBoolean("identify-by-uuid", false);
    }

    @Generated
    private Dao<Customer, String> getCustomersDao() {
        return this.customersDao;
    }

    @Generated
    private Dao<Payment, Integer> getPaymentsDao() {
        return this.paymentsDao;
    }

    @Generated
    private Dao<Purchase, Integer> getPurchasesDao() {
        return this.purchasesDao;
    }

    @FunctionalInterface
    private static interface ThrowableSupplier<T> {
        @Nullable
        public T supply() throws SQLException;
    }

    @FunctionalInterface
    private static interface ThrowableRunnable {
        public void run() throws SQLException;
    }
}

