/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Reflection {
    @Nullable
    public static Method getMethod(@NotNull Class<?> type, @NotNull String methodName, Class<?> ... parameters) {
        try {
            return type.getMethod(methodName, parameters);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Nullable
    public static Method getDeclaredMethod(@NotNull Class<?> type, @NotNull String methodName, Class<?> ... parameters) {
        try {
            Method method = type.getDeclaredMethod(methodName, parameters);
            method.setAccessible(true);
            return method;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @NotNull
    public static <T> Optional<T> invokeMethod(@Nullable Method method, @Nullable Object instance, Object ... parameters) {
        try {
            Object returnedValue = method.invoke(instance, parameters);
            return Optional.ofNullable(returnedValue);
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    public static boolean invokeVoidMethod(@Nullable Method method, @Nullable Object instance, Object ... parameters) {
        try {
            method.invoke(instance, parameters);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @NotNull
    public static Set<Method> findAllMethods(@NotNull Class<?> type) {
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        Reflection.walkClassTree(type, t -> Collections.addAll(methods, t.getMethods()));
        return methods;
    }

    @NotNull
    public static Set<Method> findAllDeclaredMethods(@NotNull Class<?> type) {
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        Reflection.walkClassTree(type, t -> Collections.addAll(methods, t.getDeclaredMethods()));
        return methods;
    }

    @NotNull
    public static Set<Field> findAllFields(@NotNull Class<?> type) {
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
        Reflection.walkClassTree(type, t -> Collections.addAll(fields, t.getFields()));
        return fields;
    }

    @NotNull
    public static Set<Field> findAllDeclaredFields(@NotNull Class<?> type) {
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
        Reflection.walkClassTree(type, t -> Collections.addAll(fields, t.getDeclaredFields()));
        return fields;
    }

    @NotNull
    public static <A extends Annotation> Map<Method, A> findAnnotatedMethods(@NotNull Class<?> type, @NotNull Class<A> annotationType) {
        return Reflection.extractAnnotations(Reflection.findAllMethods(type), annotationType, Method::getAnnotation);
    }

    @NotNull
    public static <A extends Annotation> Map<Method, A> findAnnotatedDeclaredMethods(@NotNull Class<?> type, @NotNull Class<A> annotationType) {
        return Reflection.extractAnnotations(Reflection.findAllDeclaredMethods(type), annotationType, Method::getAnnotation);
    }

    @NotNull
    public static <A extends Annotation> Map<Field, A> findAnnotatedFields(@NotNull Class<?> type, @NotNull Class<A> annotationType) {
        return Reflection.extractAnnotations(Reflection.findAllFields(type), annotationType, Field::getAnnotation);
    }

    @NotNull
    public static <A extends Annotation> Map<Field, A> findAnnotatedDeclaredFields(@NotNull Class<?> type, @NotNull Class<A> annotationType) {
        return Reflection.extractAnnotations(Reflection.findAllDeclaredFields(type), annotationType, Field::getAnnotation);
    }

    @NotNull
    public static <T, A extends Annotation> Map<T, A> extractAnnotations(@NotNull Collection<T> collection, @NotNull Class<A> annotationType, @NotNull BiFunction<T, Class<A>, A> annotationExtractor) {
        LinkedHashMap<T, Annotation> annotatedElements = new LinkedHashMap<T, Annotation>();
        for (T element : collection) {
            Annotation annotation = (Annotation)annotationExtractor.apply(element, annotationType);
            if (annotation == null) continue;
            annotatedElements.put(element, annotation);
        }
        return annotatedElements;
    }

    private static void walkClassTree(@NotNull Class<?> type, @NotNull Consumer<Class<?>> typeConsumer) {
        for (Class<?> clazz = type; clazz != null; clazz = clazz.getSuperclass()) {
            typeConsumer.accept(clazz);
        }
    }

    @Generated
    private Reflection() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

