/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.platform.scheduler;

import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.platform.scheduler.PlatformTask;
import ru.easydonate.easypayments.core.platform.scheduler.bukkit.BukkitPlatformScheduler;

public interface PlatformScheduler {
    @NotNull
    public static final String FOLIA_PLATFORM_SCHEDULER = "ru.easydonate.easypayments.platform.folia.FoliaPlatformScheduler";

    public static PlatformScheduler create(Server server, boolean runningFolia) {
        if (runningFolia) {
            try {
                Class<?> clazz = Class.forName(FOLIA_PLATFORM_SCHEDULER);
                return (PlatformScheduler)clazz.getConstructor(Server.class).newInstance(server);
            }
            catch (Exception ex) {
                throw new RuntimeException("Couldn't instantiate Folia platform scheduler!");
            }
        }
        return new BukkitPlatformScheduler(server);
    }

    public PlatformTask runAsyncNow(Plugin var1, Runnable var2);

    public PlatformTask runAsyncDelayed(Plugin var1, Runnable var2, long var3);

    public PlatformTask runAsyncAtFixedRate(Plugin var1, Runnable var2, long var3, long var5);

    public PlatformTask runSyncNow(Plugin var1, Runnable var2);

    public PlatformTask runSyncDelayed(Plugin var1, Runnable var2, long var3);

    public PlatformTask runSyncAtFixedRate(Plugin var1, Runnable var2, long var3, long var5);
}

