/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.platform.provider;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.EasyPayments;
import ru.easydonate.easypayments.core.interceptor.InterceptorFactory;
import ru.easydonate.easypayments.core.platform.provider.PlatformProvider;
import ru.easydonate.easypayments.core.platform.scheduler.PlatformScheduler;

public abstract class PlatformProviderBase
implements PlatformProvider {
    private static final String NAME = "Spigot Internals";
    protected final EasyPayments plugin;
    protected final PlatformScheduler scheduler;
    protected final Executor syncExecutor;
    protected InterceptorFactory interceptorFactory;

    public PlatformProviderBase(@NotNull EasyPayments plugin, @NotNull PlatformScheduler scheduler, @NotNull String executorName, int permissionLevel) {
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.syncExecutor = task -> scheduler.runSyncNow(plugin, task);
        this.interceptorFactory = this.createInterceptorFactory(executorName, permissionLevel);
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public final OfflinePlayer getOfflinePlayer(@NotNull String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name cannot be empty");
        Optional<Player> onlinePlayer = this.findOnlinePlayer(name);
        if (onlinePlayer.isPresent()) {
            return (OfflinePlayer)onlinePlayer.get();
        }
        return this.findOfflinePlayer(name).orElseGet(() -> this.createOfflinePlayer(name));
    }

    @Blocking
    @NotNull
    protected abstract OfflinePlayer createOfflinePlayer(@NotNull String var1);

    @NotNull
    protected abstract InterceptorFactory createInterceptorFactory(@NotNull String var1, int var2);

    public synchronized void updateInterceptorFactory(@NotNull String executorName, int permissionLevel) {
        this.interceptorFactory = this.createInterceptorFactory(executorName, permissionLevel);
    }

    @Override
    public boolean isTaskCancelled(@NotNull BukkitTask bukkitTask) {
        return bukkitTask.isCancelled();
    }

    @NotNull
    protected final UUID createOfflineUUID(@NotNull String name) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8));
    }

    @NotNull
    private Optional<Player> findOnlinePlayer(@NotNull String name) {
        for (Player candidate : this.plugin.getServer().getOnlinePlayers()) {
            if (!name.equals(candidate.getName())) continue;
            return Optional.of(candidate);
        }
        return Optional.empty();
    }

    @NotNull
    private Optional<OfflinePlayer> findOfflinePlayer(@NotNull String name) {
        for (OfflinePlayer candidate : this.plugin.getServer().getOfflinePlayers()) {
            if (!name.equals(candidate.getName())) continue;
            return Optional.of(candidate);
        }
        return Optional.empty();
    }

    @Override
    @Generated
    public EasyPayments getPlugin() {
        return this.plugin;
    }

    @Override
    @Generated
    public PlatformScheduler getScheduler() {
        return this.scheduler;
    }

    @Generated
    public Executor getSyncExecutor() {
        return this.syncExecutor;
    }

    @Override
    @Generated
    public InterceptorFactory getInterceptorFactory() {
        return this.interceptorFactory;
    }
}

