/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.placeholder;

import lombok.Generated;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.core.placeholder.PlaceholderReplacerBus;

public final class StringContainer {
    private String wrappedString;
    private final boolean supportingPlaceholders;

    @NotNull
    public static StringContainer wrap(@Nullable String wrappedString, boolean supportingPlaceholders) {
        return new StringContainer(wrappedString, supportingPlaceholders);
    }

    @NotNull
    public StringContainer copy() {
        return new StringContainer(this.wrappedString, this.supportingPlaceholders);
    }

    @Nullable
    public String get() {
        return this.wrappedString;
    }

    public boolean isEmpty() {
        return this.wrappedString == null || this.wrappedString.isEmpty();
    }

    public boolean isSupportingPlaceholders() {
        return this.supportingPlaceholders && !this.isEmpty();
    }

    @NotNull
    public StringContainer processPlaceholders(@NotNull PlaceholderReplacerBus replacerBus, @NotNull Player bukkitPlayer) {
        if (this.isEmpty()) {
            return this;
        }
        return replacerBus.processPlaceholders(bukkitPlayer, this);
    }

    @NotNull
    public String toString() {
        return "StringContainer{string='" + this.wrappedString + '\'' + ", supportingPlaceholders=" + this.supportingPlaceholders + '}';
    }

    @Generated
    private StringContainer(String wrappedString, boolean supportingPlaceholders) {
        this.wrappedString = wrappedString;
        this.supportingPlaceholders = supportingPlaceholders;
    }
}

