/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.formatting;

import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.config.localized.Messages;
import ru.easydonate.easypayments.core.formatting.RelativeTimeUnit;

public final class RelativeTimeFormatter {
    private final Messages messages;
    private final Map<RelativeTimeUnit, String> timeUnitFormats;
    private String timeUnitDelimiter;

    public RelativeTimeFormatter(@NotNull Messages messages) {
        this.messages = messages;
        this.timeUnitFormats = new ConcurrentHashMap<RelativeTimeUnit, String>();
        this.update();
    }

    public void update() {
        this.timeUnitDelimiter = this.messages.getColoredString("relative-time-format.delimiter", "");
        this.timeUnitFormats.clear();
        for (RelativeTimeUnit timeUnit : RelativeTimeUnit.values()) {
            String timeUnitFormat = this.messages.getColoredString(timeUnit.getFormatLocaleKey(), "");
            if (timeUnitFormat.isEmpty()) continue;
            this.timeUnitFormats.put(timeUnit, timeUnitFormat);
        }
    }

    @NotNull
    public String formatElapsedTime(@NotNull LocalDateTime from) {
        LocalDateTime now = LocalDateTime.now();
        int seconds = this.calculateTimeUnitValue(RelativeTimeUnit.SECONDS, from, now) % 60;
        int minutes = this.calculateTimeUnitValue(RelativeTimeUnit.MINUTES, from, now) % 60;
        int hours = this.calculateTimeUnitValue(RelativeTimeUnit.HOURS, from, now) % 24;
        int days = this.calculateTimeUnitValue(RelativeTimeUnit.DAYS, from, now);
        ArrayList<String> timeUnitValues = new ArrayList<String>();
        this.addTimeUnitValue(timeUnitValues, RelativeTimeUnit.DAYS, days);
        this.addTimeUnitValue(timeUnitValues, RelativeTimeUnit.HOURS, hours);
        this.addTimeUnitValue(timeUnitValues, RelativeTimeUnit.MINUTES, minutes);
        this.addTimeUnitValue(timeUnitValues, RelativeTimeUnit.SECONDS, seconds);
        if (timeUnitValues.isEmpty()) {
            this.addTimeUnitValue(timeUnitValues, RelativeTimeUnit.SECONDS, 1);
        }
        return String.join((CharSequence)this.timeUnitDelimiter, timeUnitValues);
    }

    private int calculateTimeUnitValue(@NotNull RelativeTimeUnit timeUnit, @NotNull Temporal from, @NotNull Temporal to) {
        return this.timeUnitFormats.containsKey((Object)timeUnit) ? (int)timeUnit.getChronoUnit().between(from, to) : 0;
    }

    private void addTimeUnitValue(@NotNull List<String> addTo, @NotNull RelativeTimeUnit timeUnit, int value) {
        if (value > 0) {
            addTo.add(this.formatTimeUnitValue(timeUnit, value));
        }
    }

    @NotNull
    private String formatTimeUnitValue(@NotNull RelativeTimeUnit timeUnit, int value) {
        String format = this.timeUnitFormats.get((Object)timeUnit);
        if (format == null) {
            return "";
        }
        try {
            return String.format(format, value);
        }
        catch (IllegalFormatException ignored) {
            return "";
        }
    }
}

