/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.object;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.EventObject;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.object.PurchasedProduct;
import ru.easydonate.easypayments.core.exception.StructureValidationException;
import ru.easydonate.easypayments.libs.gson.annotations.SerializedName;

public final class NewPaymentEvent
extends EventObject {
    @SerializedName(value="payment_id")
    private int paymentId;
    @SerializedName(value="products")
    private List<PurchasedProduct> products;

    @Override
    public void validate() throws StructureValidationException {
        super.validate();
        if (this.paymentId <= 0) {
            this.validationFail("'paymentId' must be > 0, but it's %d", this.paymentId);
        }
        if (this.products == null || this.products.isEmpty()) {
            this.validationFail("no products present", new Object[0]);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NewPaymentEvent that = (NewPaymentEvent)o;
        return this.paymentId == that.paymentId && Objects.equals(this.products, that.products);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.paymentId, this.products);
    }

    @Override
    @NotNull
    public String toString() {
        return "NewPaymentEvent{customer='" + this.customer + '\'' + ", createdAt=" + this.createdAt + ", pluginEvents=" + this.pluginEvents + ", paymentId=" + this.paymentId + ", products=" + this.products + '}';
    }

    @Generated
    public int getPaymentId() {
        return this.paymentId;
    }

    @Generated
    public List<PurchasedProduct> getProducts() {
        return this.products;
    }
}

