/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.easydonate4j.json.serialization;

import java.lang.reflect.Type;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.easydonate4j.EventType;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.EventObject;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.EventUpdate;
import ru.easydonate.easypayments.libs.gson.JsonArray;
import ru.easydonate.easypayments.libs.gson.JsonDeserializationContext;
import ru.easydonate.easypayments.libs.gson.JsonDeserializer;
import ru.easydonate.easypayments.libs.gson.JsonElement;
import ru.easydonate.easypayments.libs.gson.JsonObject;
import ru.easydonate.easypayments.libs.gson.JsonParseException;
import ru.easydonate.easypayments.libs.gson.reflect.TypeToken;

public final class EventUpdateDeserializer
implements JsonDeserializer<EventUpdate<?>> {
    private static final EventUpdateDeserializer SINGLETON = new EventUpdateDeserializer();

    @NotNull
    public static EventUpdateDeserializer getSingleton() {
        return SINGLETON;
    }

    @Override
    public EventUpdate<?> deserialize(JsonElement json, Type objectType, JsonDeserializationContext context) throws JsonParseException {
        return this.deserialize0(json, objectType, context);
    }

    private <E extends EventObject> EventUpdate<E> deserialize0(JsonElement json, Type objectType, JsonDeserializationContext context) throws JsonParseException {
        JsonObject rootObject = json.getAsJsonObject();
        String rawType = rootObject.get("type").getAsString();
        EventType type = EventType.getByKey(rawType);
        if (type == EventType.UNKNOWN) {
            return null;
        }
        List eventObjects = null;
        if (rootObject.has("objects")) {
            JsonArray rawEventObjects = rootObject.getAsJsonArray("objects");
            Class<? extends EventObject> eventObjectClass = type.getEventObjectClass();
            eventObjects = (List)context.deserialize(rawEventObjects, TypeToken.getParameterized(List.class, new Type[]{eventObjectClass}).getType());
        }
        return new EventUpdate(type, eventObjects);
    }

    @Generated
    private EventUpdateDeserializer() {
    }
}

