/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.easydonate4j.extension.client;

import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.easydonate4j.extension.client.EasyPaymentsClient;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventUpdateReports;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.PluginStateModel;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.PluginVersionModel;
import ru.easydonate.easypayments.core.easydonate4j.extension.response.PluginStateResponse;
import ru.easydonate.easypayments.core.easydonate4j.extension.response.PluginVersionResponse;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.client.LongPollClient;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.client.SimpleEasyDonateClient;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.ResponseContentDeserializer;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpRequestException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpResponseException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.JsonSerializationException;
import ru.easydonate.easypayments.libs.easydonate4j.http.QueryParams;
import ru.easydonate.easypayments.libs.easydonate4j.http.client.HttpClient;
import ru.easydonate.easypayments.libs.easydonate4j.http.request.EasyHttpRequest;
import ru.easydonate.easypayments.libs.easydonate4j.http.response.EasyHttpResponse;

final class SimpleEasyPaymentsClient
extends SimpleEasyDonateClient
implements EasyPaymentsClient {
    private static final String CHECK_FOR_UPDATES_URL = "https://ep.easydonate.ru/updates?version=%s&edition=je";
    private final LongPollClient longPollClient;

    SimpleEasyPaymentsClient(@NotNull String accessKey, @NotNull String userAgent, int serverId) {
        super(accessKey, userAgent, 5000L, 5000L, 5000L, 5000L);
        this.longPollClient = LongPollClient.create(accessKey, serverId, userAgent);
    }

    @Override
    @NotNull
    public PluginVersionModel getPluginVersion(@NotNull String currentVersion) throws HttpRequestException, HttpResponseException {
        QueryParams queryParams = new QueryParams().set("version", currentVersion).set("edition", "je");
        EasyHttpRequest httpRequest = this.createRequest(HttpClient.Method.GET).setHeaders(this.defaultHeaders).setQueryParams(queryParams).setUrl(CHECK_FOR_UPDATES_URL, currentVersion).build();
        return (PluginVersionModel)this.request(PluginVersionResponse.class, httpRequest);
    }

    @Override
    @NotNull
    public PluginStateModel getPluginState() throws HttpRequestException, HttpResponseException {
        EasyHttpResponse response = this.longPollClient.makeCustomRequest(HttpClient.Method.GET, builder -> builder.setApiPath("/state", new Object[0]));
        return (PluginStateModel)ResponseContentDeserializer.deserializeResponseContent(PluginStateResponse.class, response);
    }

    @Override
    public boolean uploadKnownPlayers(@NotNull Map<String, Boolean> knownPlayers) throws HttpRequestException {
        if (knownPlayers.isEmpty()) {
            return false;
        }
        try {
            String jsonBody = this.jsonSerialization.serialize(knownPlayers);
            EasyHttpResponse response = this.longPollClient.makeCustomRequest(HttpClient.Method.POST, builder -> builder.setApiPath("/players", new Object[0]).setBody(jsonBody));
            return response.isSuccess();
        }
        catch (JsonSerializationException ignored) {
            return false;
        }
    }

    @Override
    public boolean uploadReports(@NotNull EventUpdateReports updateReports) throws HttpRequestException {
        try {
            String jsonBody = this.jsonSerialization.serialize(updateReports);
            EasyHttpResponse response = this.longPollClient.makeCustomRequest(HttpClient.Method.POST, builder -> builder.setApiPath("/report", new Object[0]).setBody(jsonBody));
            return response.isSuccess();
        }
        catch (JsonSerializationException ignored) {
            return false;
        }
    }

    @Override
    @Generated
    public LongPollClient getLongPollClient() {
        return this.longPollClient;
    }
}

