/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.config.template;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class TemplateWriter {
    private static final Pattern CONFIG_LINE_REGEX = Pattern.compile("^(?<offset> +)?(?<key>[\\w-]+):\\s?(?<value>_value_)?");
    private final Path outputFile;
    private final List<String> template;
    private final Map<String, Object> data;
    private final Map<String, String[]> keyAliases;

    public void write() throws IOException {
        if (!Files.isDirectory(this.outputFile.getParent(), new LinkOption[0])) {
            Files.createDirectories(this.outputFile.getParent(), new FileAttribute[0]);
        }
        List<String> content = this.processTemplate();
        Files.write(this.outputFile, content, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private List<String> processTemplate() {
        ArrayList<String> keyPath = new ArrayList<String>();
        for (int i = 0; i < this.template.size(); ++i) {
            Matcher matcher;
            String line = this.template.get(i);
            if (line.isEmpty() || line.trim().startsWith("#") || !(matcher = CONFIG_LINE_REGEX.matcher(line)).find()) continue;
            String key = matcher.group("key");
            String rawOffset = matcher.group("offset");
            int offset = this.toDigitOffset(rawOffset);
            int level = offset / 2;
            if (matcher.group("value") != null) {
                String fullKey = this.toConfigKey(keyPath, key, level);
                Object value = this.resolveConfigValue(fullKey);
                int valueStartAt = matcher.start("value");
                int valueEndAt = matcher.end("value");
                i += this.insertConfigValue(i, valueStartAt, valueEndAt, rawOffset, key, value);
                continue;
            }
            if (keyPath.size() > level) {
                keyPath.set(level, key);
                continue;
            }
            keyPath.add(key);
        }
        return this.template;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int insertConfigValue(int lineIndex, int start, int end, String offset, String key, Object value) {
        if (value instanceof String) {
            String asString = (String)value;
            if (!asString.contains("\n")) {
                this.insertConfigStringValue(lineIndex, start, end, asString);
                return 0;
            }
            boolean nextLineIsEmpty = false;
            if (lineIndex < this.template.size() - 1) {
                String nextLine = this.template.get(lineIndex + 1);
                nextLineIsEmpty = nextLine.trim().isEmpty();
            }
            this.insertConfigValueInline(lineIndex, start, end, nextLineIsEmpty ? "|-" : "|");
            String[] lines = asString.split("\n");
            int insertStart = lineIndex + 1;
            String linePrefix = (offset != null ? offset : "") + "  ";
            int i = 0;
            int count = lines.length;
            while (i < count) {
                this.template.add(insertStart + i, linePrefix + lines[i]);
                ++i;
            }
            return lines.length;
        }
        if (value instanceof List) {
            List asList = (List)value;
            if (asList.isEmpty()) {
                this.insertConfigValueInline(lineIndex, start, end, "[]");
                return 0;
            }
            this.template.set(lineIndex, offset + key + ':');
            int insertStart = lineIndex + 1;
            String listItemLine = offset + "- _value_";
            int listItemValueStart = offset.length() + 2;
            int listItemValueEnd = listItemValueStart + 7;
            int i = 0;
            int count = asList.size();
            while (i < count) {
                int index = insertStart + i;
                this.template.add(index, listItemLine);
                this.insertConfigStringValue(index, listItemValueStart, listItemValueEnd, asList.get(i));
                ++i;
            }
            return asList.size();
        }
        this.insertConfigValueInline(lineIndex, start, end, value != null ? value : "");
        return 0;
    }

    private void insertConfigStringValue(int lineIndex, int start, int end, Object value) {
        String asString = String.valueOf(value);
        boolean isOneWord = asString.matches("\\w+");
        boolean containsApostrophe = asString.contains("'");
        if (containsApostrophe) {
            asString = asString.replace("\"", "\\\"");
            this.insertConfigValueInline(lineIndex, start, end, '\"' + asString + '\"');
        } else if (isOneWord) {
            this.insertConfigValueInline(lineIndex, start, end, asString);
        } else {
            this.insertConfigValueInline(lineIndex, start, end, '\'' + asString + '\'');
        }
    }

    private void insertConfigValueInline(int lineIndex, int start, int end, Object value) {
        String line = this.template.get(lineIndex);
        String replaced = new StringBuilder(line).replace(start, end, String.valueOf(value)).toString();
        this.template.set(lineIndex, replaced);
    }

    private Object resolveConfigValue(String key) {
        Object value;
        String[] aliases;
        if (this.keyAliases != null && !this.keyAliases.isEmpty() && (aliases = this.keyAliases.get(key)) != null) {
            for (String alias : aliases) {
                Object value2 = this.data.get(alias);
                if (value2 == null) continue;
                return value2;
            }
        }
        return (value = this.data.get(key)) == null ? "" : value;
    }

    private int toDigitOffset(String offset) {
        return offset != null ? offset.length() : 0;
    }

    private String toConfigKey(List<String> keyPath, String key, int level) {
        if (level == 0 || keyPath.isEmpty()) {
            return key;
        }
        if (keyPath.size() >= level) {
            keyPath = keyPath.subList(0, level);
        }
        return String.join((CharSequence)".", keyPath) + '.' + key;
    }

    @Generated
    public TemplateWriter(Path outputFile, List<String> template, Map<String, Object> data, Map<String, String[]> keyAliases) {
        this.outputFile = outputFile;
        this.template = template;
        this.data = data;
        this.keyAliases = keyAliases;
    }
}

