/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.config.template;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.EasyPayments;
import ru.easydonate.easypayments.core.config.ConfigurationBase;
import ru.easydonate.easypayments.core.config.template.TemplateWriter;
import ru.easydonate.easypayments.core.exception.ConfigurationValidationException;
import ru.easydonate.easypayments.core.util.FileBackupMaker;

public abstract class TemplateConfigurationBase
extends ConfigurationBase {
    public static final String VALUE_PLACEHOLDER = "_value_";
    protected final EasyPayments plugin;
    protected final Map<String, String[]> keyAliases;
    protected FileConfiguration bukkitConfig;

    public TemplateConfigurationBase(@NotNull EasyPayments plugin) {
        this.plugin = plugin;
        this.keyAliases = new HashMap<String, String[]>();
        this.bukkitConfig = new YamlConfiguration();
    }

    @NotNull
    protected abstract String getResourcePath();

    @NotNull
    protected abstract Path getOutputFile();

    @Override
    @NotNull
    protected FileConfiguration getBukkitConfiguration() {
        return this.bukkitConfig;
    }

    @Override
    public void registerKeyAliases(@NotNull String key, String ... aliases) {
        if (aliases != null && aliases.length != 0) {
            this.keyAliases.put(key, aliases);
        }
    }

    @Override
    public synchronized boolean reload() throws ConfigurationValidationException {
        Map<String, Object> overrides;
        boolean hasOverrides;
        String resourcePath = this.getResourcePath();
        this.plugin.getDebugLogger().debug("Loading configuration '{0}'...", resourcePath);
        List<String> template = this.loadTemplate(resourcePath);
        if (template == null) {
            return false;
        }
        Map<String, Object> defaults = this.loadDefaults(resourcePath);
        if (defaults == null) {
            return false;
        }
        Path outputFile = this.getOutputFile();
        boolean outputFileExists = Files.isRegularFile(outputFile, new LinkOption[0]);
        Map<String, Object> existing = null;
        if (outputFileExists) {
            try {
                existing = TemplateConfigurationBase.loadConfigurationAsMap(Files.newBufferedReader(outputFile, StandardCharsets.UTF_8));
            }
            catch (IOException ex) {
                this.plugin.getLogger().severe(String.format("Couldn't read existing configuration in '%s': %s", outputFile, ex.getMessage()));
                this.plugin.getDebugLogger().error("Couldn't read existing configuration in '{0}'", outputFile);
                this.plugin.getDebugLogger().error(ex);
                return false;
            }
        }
        boolean bl = hasOverrides = !(overrides = this.getOverrides()).isEmpty();
        if (hasOverrides || TemplateConfigurationBase.isConfigurationOutdated(defaults, existing)) {
            if (outputFileExists && !hasOverrides) {
                this.plugin.getDebugLogger().info("Configuration '{0}' is outdated! Performing update...", resourcePath);
                try {
                    Path backupFilePath = FileBackupMaker.createFileBackup(outputFile);
                    if (backupFilePath != null) {
                        this.plugin.getDebugLogger().info("Configuration backup has been saved to: {0}", backupFilePath);
                    }
                }
                catch (IOException ex) {
                    this.plugin.getLogger().severe("Couldn't create a backup file: " + ex.getMessage());
                    this.plugin.getDebugLogger().error("Couldn't create a backup file", new Object[0]);
                    this.plugin.getDebugLogger().error(ex);
                    return false;
                }
            }
            Map<String, Object> dataValues = TemplateConfigurationBase.mergeConfigurationData(defaults, existing);
            if (hasOverrides) {
                dataValues = TemplateConfigurationBase.mergeConfigurationData(dataValues, overrides);
            }
            try {
                new TemplateWriter(outputFile, template, dataValues, this.keyAliases).write();
            }
            catch (IOException ex) {
                this.plugin.getLogger().severe(String.format("Couldn't save generated configuration as '%s': %s", outputFile, ex.getMessage()));
                this.plugin.getDebugLogger().error("Couldn't save generated configuration as '{0}'", outputFile);
                this.plugin.getDebugLogger().error(ex);
                return false;
            }
        }
        try {
            this.bukkitConfig.load((Reader)Files.newBufferedReader(outputFile, StandardCharsets.UTF_8));
        }
        catch (IOException | InvalidConfigurationException ex) {
            this.plugin.getLogger().severe("Couldn't load configuration: " + ex.getMessage());
            this.plugin.getDebugLogger().error("Couldn't load configuration", new Object[0]);
            this.plugin.getDebugLogger().error(ex);
            return false;
        }
        this.resetOverrides();
        this.validate();
        this.plugin.getDebugLogger().info("Loaded configuration '{0}'", resourcePath);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> loadDefaults(String resourcePath) {
        try (InputStream stream = this.resolveResource("/assets/defaults/" + resourcePath);){
            InputStreamReader inputStreamReader = new InputStreamReader(stream, StandardCharsets.UTF_8);
            Map<String, Object> map = TemplateConfigurationBase.loadConfigurationAsMap(inputStreamReader);
            return map;
        }
        catch (IOException ex) {
            this.plugin.getLogger().severe(String.format("Couldn't load defaults resource for configuration '%s': %s", resourcePath, ex.getMessage()));
            this.plugin.getDebugLogger().error("Couldn't load defaults resource for configuration '{0}'", resourcePath);
            this.plugin.getDebugLogger().error(ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> loadTemplate(String resourcePath) {
        try (InputStream stream = this.resolveResource("/assets/templates/" + resourcePath);){
            InputStreamReader inputStreamReader = new InputStreamReader(stream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            List list = bufferedReader.lines().collect(Collectors.toCollection(ArrayList::new));
            return list;
        }
        catch (IOException ex) {
            this.plugin.getLogger().severe(String.format("Couldn't load template resource for configuration '%s': %s", resourcePath, ex.getMessage()));
            this.plugin.getDebugLogger().error("Couldn't load template resource for configuration '{0}'", resourcePath);
            this.plugin.getDebugLogger().error(ex);
            return null;
        }
    }

    private InputStream resolveResource(String resourcePath) throws IOException {
        URL url = this.getClass().getResource(resourcePath);
        if (url == null) {
            throw new IOException("resource not found");
        }
        return url.openStream();
    }

    private static boolean isConfigurationOutdated(Map<String, Object> defaults, Map<String, Object> existing) {
        if (defaults == null || defaults.isEmpty()) {
            return false;
        }
        if (existing == null || existing.isEmpty()) {
            return true;
        }
        if (defaults.size() != existing.size()) {
            return true;
        }
        for (String defaultsKey : defaults.keySet()) {
            if (existing.get(defaultsKey) != null) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Object> mergeConfigurationData(Map<String, Object> defaults, Map<String, Object> existing) {
        if (existing == null || existing.isEmpty()) {
            return defaults;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(defaults);
        existing.forEach((key, value) -> {
            if (value != null && !VALUE_PLACEHOLDER.equals(value)) {
                resultMap.put((String)key, value);
            }
        });
        return resultMap;
    }

    private static Map<String, Object> loadConfigurationAsMap(Reader reader) {
        YamlConfiguration defaultsConfig = YamlConfiguration.loadConfiguration((Reader)reader);
        HashMap<String, Object> defaultsMap = new HashMap<String, Object>(defaultsConfig.getValues(true));
        defaultsMap.entrySet().removeIf(entry -> entry.getValue() instanceof ConfigurationSection);
        return defaultsMap;
    }
}

