/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.config.localized;

import java.nio.file.Path;
import java.util.function.Consumer;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.core.EasyPayments;
import ru.easydonate.easypayments.core.config.Configuration;
import ru.easydonate.easypayments.core.config.localized.LocalizedConfigurationBase;
import ru.easydonate.easypayments.core.formatting.StringFormatter;

public final class Messages
extends LocalizedConfigurationBase {
    public static final String LANG_KEY = "lang";
    public static final String UNDEFINED_MESSAGE_FORMAT = ChatColor.RED + "Undefined message '%s'";

    public Messages(@NotNull EasyPayments plugin, @NotNull Configuration config) {
        super(plugin, config);
    }

    @Override
    public String getName() {
        return this.getResourcePath();
    }

    @Override
    @NotNull
    protected String getConfigLangKey() {
        return LANG_KEY;
    }

    @Override
    @NotNull
    protected String getResourcePath() {
        return String.format("lang/%s.yml", this.getUsedLocale().getLanguageTag());
    }

    @Override
    @NotNull
    protected Path getOutputFile() {
        String fileName = String.format("messages_%s.yml", this.getUsedLocale().getLanguageTag());
        return this.plugin.getDataFolder().toPath().resolve(LANG_KEY).resolve(fileName);
    }

    @NotNull
    public String get(@NotNull String key, Object ... args) {
        return StringFormatter.format(this.getColoredString(key, () -> String.format(UNDEFINED_MESSAGE_FORMAT, key)), args);
    }

    @NotNull
    public String getOrDefault(@NotNull String key, @Nullable String def, Object ... args) {
        return StringFormatter.format(this.getColoredString(key, def), args);
    }

    @NotNull
    public Messages getAndSend(@NotNull CommandSender sender, @NotNull String key, Object ... args) {
        String message = StringFormatter.format(this.getColoredString(key), args);
        return this.send(sender, message);
    }

    @NotNull
    public Messages getAndSend(@NotNull Consumer<String> sendFunction, @NotNull String key, Object ... args) {
        String message = StringFormatter.format(this.getColoredString(key), args);
        sendFunction.accept(message);
        return this;
    }

    @NotNull
    public Messages send(@NotNull CommandSender sender, @NotNull String message) {
        if (message != null && !message.isEmpty()) {
            if (sender instanceof Player) {
                sender.sendMessage(message);
            } else {
                for (String line : message.split("\n")) {
                    sender.sendMessage(line);
                }
            }
        }
        return this;
    }
}

