/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.config.localized;

import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.EasyPayments;
import ru.easydonate.easypayments.core.config.Configuration;
import ru.easydonate.easypayments.core.config.localized.LocaleEnum;
import ru.easydonate.easypayments.core.config.localized.LocalizedConfiguration;
import ru.easydonate.easypayments.core.config.template.TemplateConfigurationBase;
import ru.easydonate.easypayments.core.exception.ConfigurationValidationException;

public abstract class LocalizedConfigurationBase
extends TemplateConfigurationBase
implements LocalizedConfiguration {
    private final Configuration config;
    private LocaleEnum usedLocale;

    public LocalizedConfigurationBase(EasyPayments plugin, Configuration config) {
        super(plugin);
        this.config = config;
        this.usedLocale = LocaleEnum.getSystemDefault();
    }

    @NotNull
    protected abstract String getConfigLangKey();

    @Override
    @NotNull
    public LocaleEnum getUsedLocale() {
        return this.usedLocale;
    }

    @Override
    @NotNull
    public LocaleEnum resolveLocale() {
        LocaleEnum locale;
        String langValue = this.config.getString(this.getConfigLangKey());
        if (langValue != null && (locale = LocaleEnum.getByTag(langValue)) != null) {
            return locale;
        }
        this.plugin.getLogger().warning("Bad locale tag is specified in the config, switching to system default...");
        this.plugin.getDebugLogger().warn("Bad locale tag is specified in the config, switching to system default...", new Object[0]);
        return LocaleEnum.getSystemDefault();
    }

    @Override
    public synchronized boolean reload() throws ConfigurationValidationException {
        this.usedLocale = this.resolveLocale();
        return super.reload();
    }
}

