/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.config.localized;

import java.util.Locale;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LocaleEnum {
    ENGLISH("en-US"),
    RUSSIAN("ru-RU");

    private final String languageTag;

    @NotNull
    public static LocaleEnum getSystemDefault() {
        String languageTag = Locale.getDefault().toLanguageTag();
        LocaleEnum found = LocaleEnum.getByTag(languageTag);
        return found != null ? found : ENGLISH;
    }

    @Nullable
    public static LocaleEnum getByTag(@Nullable String languageTag) {
        if (languageTag != null && !languageTag.isEmpty()) {
            for (LocaleEnum locale : LocaleEnum.values()) {
                if (!locale.getLanguageTag().equalsIgnoreCase(languageTag)) continue;
                return locale;
            }
        }
        return null;
    }

    @Generated
    public String getLanguageTag() {
        return this.languageTag;
    }

    @Generated
    private LocaleEnum(String languageTag) {
        this.languageTag = languageTag;
    }
}

