/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.core.config.Configuration;
import ru.easydonate.easypayments.core.config.ConfigurationValidator;
import ru.easydonate.easypayments.core.exception.ConfigurationValidationException;
import ru.easydonate.easypayments.core.formatting.StringFormatter;

public abstract class ConfigurationBase
implements Configuration {
    private final Map<String, Object> overrides = new HashMap<String, Object>();
    private ConfigurationValidator validator;

    @NotNull
    protected abstract FileConfiguration getBukkitConfiguration();

    protected final void validate() throws ConfigurationValidationException {
        if (this.validator != null) {
            this.validator.validate(this);
        }
    }

    protected final void resetOverrides() {
        this.overrides.clear();
    }

    @Override
    @Nullable
    public ConfigurationSection getSection(@NotNull String path) {
        return this.getBukkitConfiguration().getConfigurationSection(path);
    }

    @Override
    @Nullable
    public String getColoredString(@NotNull String path) {
        return StringFormatter.colorize(this.getString(path));
    }

    @Override
    @Nullable
    public String getColoredString(@NotNull String path, @Nullable String def) {
        return StringFormatter.colorize(this.getString(path, def));
    }

    @Override
    @Nullable
    public String getColoredString(@NotNull String path, @Nullable Supplier<String> def) {
        return StringFormatter.colorize(this.getString(path, def));
    }

    @Override
    @Nullable
    public String getString(@NotNull String path) {
        return this.getBukkitConfiguration().getString(path);
    }

    @Override
    @Nullable
    public String getString(@NotNull String path, @Nullable String def) {
        return this.getBukkitConfiguration().getString(path, def);
    }

    @Override
    @Nullable
    public String getString(@NotNull String path, @NotNull Supplier<String> def) {
        String value = this.getBukkitConfiguration().getString(path);
        return value != null ? value : def.get();
    }

    @Override
    @NotNull
    public List<String> getStringList(@NotNull String path) {
        return this.getBukkitConfiguration().getStringList(path);
    }

    @Override
    public boolean getBoolean(@NotNull String path) {
        return this.getBukkitConfiguration().getBoolean(path);
    }

    @Override
    public boolean getBoolean(@NotNull String path, boolean def) {
        return this.getBukkitConfiguration().getBoolean(path, def);
    }

    @Override
    public int getInt(@NotNull String path) {
        return this.getBukkitConfiguration().getInt(path);
    }

    @Override
    public int getInt(@NotNull String path, int def) {
        return this.getBukkitConfiguration().getInt(path, def);
    }

    @Override
    public int getIntWithBounds(@NotNull String path, int min, int max) {
        return Math.min(Math.max(this.getInt(path), min), max);
    }

    @Override
    public int getIntWithBounds(@NotNull String path, int min, int max, int def) {
        return Math.min(Math.max(this.getInt(path, def), min), max);
    }

    @Override
    @NotNull
    public List<Integer> getIntList(@NotNull String path) {
        return this.getBukkitConfiguration().getIntegerList(path);
    }

    @Override
    public double getDouble(@NotNull String path) {
        return this.getBukkitConfiguration().getDouble(path);
    }

    @Override
    public double getDouble(@NotNull String path, double def) {
        return this.getBukkitConfiguration().getDouble(path, def);
    }

    @Override
    @Generated
    public Map<String, Object> getOverrides() {
        return this.overrides;
    }

    @Override
    @Generated
    public ConfigurationValidator getValidator() {
        return this.validator;
    }

    @Override
    @Generated
    public void setValidator(ConfigurationValidator validator) {
        this.validator = validator;
    }
}

