/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.command.shopcart;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.command.CommandExecutor;
import ru.easydonate.easypayments.command.annotation.Arguments;
import ru.easydonate.easypayments.command.annotation.Command;
import ru.easydonate.easypayments.command.annotation.CommandAliases;
import ru.easydonate.easypayments.command.annotation.Permission;
import ru.easydonate.easypayments.command.annotation.PluginEnableRequired;
import ru.easydonate.easypayments.command.exception.ExecutionException;
import ru.easydonate.easypayments.command.exception.InitializationException;
import ru.easydonate.easypayments.core.config.localized.Messages;
import ru.easydonate.easypayments.database.model.Payment;
import ru.easydonate.easypayments.database.model.Purchase;
import ru.easydonate.easypayments.shopcart.ShopCart;
import ru.easydonate.easypayments.shopcart.ShopCartStorage;

@Command(value="browse")
@CommandAliases(value={"check", "list", "content"})
@Arguments(value={"player"})
@PluginEnableRequired
@Permission(value="easypayments.command.cart.browse")
public final class CommandBrowse
extends CommandExecutor {
    private static final String BROWSE_OTHERS_PERMISSION = "easypayments.command.cart.browse.other";
    private final EasyPaymentsPlugin plugin;
    private final ShopCartStorage shopCartStorage;

    public CommandBrowse(@NotNull EasyPaymentsPlugin plugin, @NotNull Messages messages, @NotNull ShopCartStorage shopCartStorage) throws InitializationException {
        super(messages);
        this.plugin = plugin;
        this.shopCartStorage = shopCartStorage;
    }

    @Override
    public void executeCommand(@NotNull CommandSender sender, @NotNull List<String> args) throws ExecutionException {
        this.validateExecution(sender, args);
        if (!args.isEmpty() && sender.hasPermission(BROWSE_OTHERS_PERMISSION)) {
            this.showCartContent(sender, args.get(0), !this.isPlayer(sender) || !sender.getName().equals(args.get(0)));
            return;
        }
        if (!this.isPlayer(sender)) {
            this.throwWrongSyntax();
        }
        this.showCartContent(sender, sender.getName(), false);
    }

    @Override
    @Nullable
    public List<String> provideTabCompletions(@NotNull CommandSender sender, @NotNull List<String> args) throws ExecutionException {
        this.validateExecution(sender, args);
        if (args.size() != 1) {
            return null;
        }
        String arg = args.get(0).toLowerCase();
        if (sender.hasPermission(BROWSE_OTHERS_PERMISSION)) {
            return Arrays.stream(this.plugin.getServer().getOfflinePlayers()).map(OfflinePlayer::getName).distinct().filter(n -> n.toLowerCase().startsWith(arg)).collect(Collectors.toList());
        }
        if (this.isPlayer(sender) && sender.getName().toLowerCase().startsWith(arg)) {
            return Collections.singletonList(sender.getName());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showCartContent(@NotNull CommandSender sender, @NotNull String playerName, boolean browsingOthers) throws ExecutionException {
        String messagesRoot = browsingOthers ? "cart-browse.other" : "cart-browse.yourself";
        CompletableFuture<ShopCart> shopCartFuture = new CompletableFuture<ShopCart>();
        Optional<ShopCart> cachedCart = this.shopCartStorage.getCached(playerName);
        if (!browsingOthers) {
            if (!cachedCart.isPresent()) {
                this.plugin.getLogger().warning(String.format("%s's shop cart still isn't cached!", playerName));
                this.plugin.getLogger().warning("Probably a database connection is very slow...");
                throw new ExecutionException(this.messages.get(messagesRoot + ".failed.cart-unavailable", new Object[0]), new Object[0]);
            }
            shopCartFuture.complete(cachedCart.get());
        } else if (cachedCart.isPresent()) {
            shopCartFuture.complete(cachedCart.get());
        } else {
            this.shopCartStorage.getAndCache(playerName).thenAccept(shopCartFuture::complete);
        }
        shopCartFuture.thenAccept(shopCart -> {
            List purchases;
            Collection<Payment> cartContent;
            Collection<Payment> collection = cartContent = shopCart != null ? shopCart.getContent() : null;
            if (cartContent != null && !cartContent.isEmpty() && !(purchases = cartContent.stream().filter(Payment::hasPurchases).map(Payment::getPurchases).flatMap(Collection::stream).filter(p -> !p.isCollected()).map(purchase -> this.asBodyElement((Purchase)purchase, messagesRoot)).collect(Collectors.toList())).isEmpty()) {
                ArrayList<String> message = new ArrayList<String>();
                message.add(this.messages.get(messagesRoot + ".header", "%player%", playerName));
                message.addAll(purchases);
                message.add(this.messages.get(messagesRoot + ".footer", "%player%", playerName));
                message.removeIf(String::isEmpty);
                this.messages.send(sender, String.join((CharSequence)"\n", message));
                return;
            }
            this.messages.getAndSend(sender, messagesRoot + ".failed.no-purchases", "%player%", playerName);
        });
    }

    @NotNull
    private String asBodyElement(@NotNull Purchase purchase, @NotNull String messagesRoot) {
        String name = purchase.getName();
        int amount = purchase.getAmount();
        LocalDateTime createdAt = purchase.getCreatedAt();
        return this.messages.get(messagesRoot + ".body", "%name%", name != null ? name : this.getNoValueStub(messagesRoot), "%amount%", Math.max(amount, 1), "%time_ago%", this.plugin.getRelativeTimeFormatter().formatElapsedTime(createdAt));
    }

    @NotNull
    private String getNoValueStub(@NotNull String messagesRoot) {
        return this.messages.get(messagesRoot + ".no-value-stub", new Object[0]);
    }
}

