/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.command.help;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.command.help.HelpMessage;
import ru.easydonate.easypayments.command.help.HelpMessageLine;
import ru.easydonate.easypayments.core.config.localized.Messages;

public final class HelpMessageFactory {
    private final Messages messages;
    private final List<HelpMessageLine> lines;
    private String argumentKeyFormat;
    private String descriptionKeyFormat;
    private String permissionFormat;
    private Supplier<String> headerStub;
    private Supplier<String> lineFormat;
    private Supplier<String> footerStub;

    private HelpMessageFactory(@NotNull Messages messages) {
        this.messages = messages;
        this.lines = new ArrayList<HelpMessageLine>();
    }

    @NotNull
    public static HelpMessageFactory newFactory(@NotNull Messages messages) {
        return new HelpMessageFactory(messages);
    }

    @NotNull
    public HelpMessage constructMessage() {
        return HelpMessage.builder().withHeaderStub(this.headerStub).withLineFormat(this.lineFormat).withFooterStub(this.footerStub).withLines(this.lines).create();
    }

    @NotNull
    public HelpMessageFactory addLine(@NotNull HelpMessageLine line) {
        this.lines.add(line);
        return this;
    }

    @NotNull
    public HelpMessageLine newLine() {
        return new HelpMessageLine(this);
    }

    @NotNull
    public HelpMessageFactory withArgumentKeyFormat(@NotNull String argumentKeyFormat) {
        this.argumentKeyFormat = argumentKeyFormat;
        return this;
    }

    @NotNull
    public HelpMessageFactory withDescriptionKeyFormat(@NotNull String descriptionKeyFormat) {
        this.descriptionKeyFormat = descriptionKeyFormat;
        return this;
    }

    @NotNull
    public HelpMessageFactory withPermissionFormat(@NotNull String permissionFormat) {
        this.permissionFormat = permissionFormat;
        return this;
    }

    @NotNull
    public HelpMessageFactory withHeader(@NotNull String header) {
        this.headerStub = () -> header;
        return this;
    }

    @NotNull
    public HelpMessageFactory withHeaderFrom(@NotNull String key) {
        this.headerStub = () -> this.messages.get(key, new Object[0]);
        return this;
    }

    @NotNull
    public HelpMessageFactory withLineFormat(@NotNull String lineFormat) {
        this.lineFormat = () -> lineFormat;
        return this;
    }

    @NotNull
    public HelpMessageFactory withLineFormatFrom(@NotNull String key) {
        this.lineFormat = () -> this.messages.get(key, new Object[0]);
        return this;
    }

    @NotNull
    public HelpMessageFactory withFooter(@NotNull String footer) {
        this.footerStub = () -> footer;
        return this;
    }

    @NotNull
    public HelpMessageFactory withFooterFrom(@NotNull String key) {
        this.footerStub = () -> this.messages.get(key, new Object[0]);
        return this;
    }

    @NotNull
    Messages getMessages() {
        return this.messages;
    }

    @NotNull
    Supplier<String> getArgument(@NotNull String key) {
        String path = this.argumentKeyFormat != null ? String.format(this.argumentKeyFormat, key) : key;
        return () -> this.messages.getOrDefault(path, path, new Object[0]);
    }

    @NotNull
    Supplier<String> getDescription(@NotNull String key) {
        String path = this.descriptionKeyFormat != null ? String.format(this.descriptionKeyFormat, key) : key;
        return () -> this.messages.getOrDefault(path, path, new Object[0]);
    }

    @NotNull
    String getPermission(@NotNull String key) {
        return this.permissionFormat != null ? String.format(this.permissionFormat, key) : key;
    }
}

