/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.command.help;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.command.help.HelpMessageLine;

public final class HelpMessage {
    private final Supplier<String> headerStub;
    private final Supplier<String> lineFormat;
    private final Supplier<String> footerStub;
    private final List<HelpMessageLine> lines;

    @NotNull
    public List<String> getAsMultiLineMessage(@NotNull Permissible receiver) {
        ArrayList<String> content = new ArrayList<String>();
        if (this.headerStub != null) {
            content.add(this.headerStub.get());
        }
        if (this.lineFormat != null && !this.lines.isEmpty()) {
            this.lines.forEach(line -> line.formatAsMessageLine(receiver, this.lineFormat.get(), content));
        }
        if (this.footerStub != null) {
            content.add(this.footerStub.get());
        }
        return content;
    }

    public void sendTo(@NotNull CommandSender receiver) {
        List<String> message = this.getAsMultiLineMessage((Permissible)receiver);
        if (receiver instanceof Player) {
            receiver.sendMessage(String.join((CharSequence)"\n", message));
        } else {
            message.forEach(arg_0 -> ((CommandSender)receiver).sendMessage(arg_0));
        }
    }

    @Generated
    HelpMessage(Supplier<String> headerStub, Supplier<String> lineFormat, Supplier<String> footerStub, List<HelpMessageLine> lines) {
        this.headerStub = headerStub;
        this.lineFormat = lineFormat;
        this.footerStub = footerStub;
        this.lines = lines;
    }

    @Generated
    static Builder builder() {
        return new Builder();
    }

    @Generated
    static class Builder {
        @Generated
        private Supplier<String> headerStub;
        @Generated
        private Supplier<String> lineFormat;
        @Generated
        private Supplier<String> footerStub;
        @Generated
        private List<HelpMessageLine> lines;

        @Generated
        Builder() {
        }

        @Generated
        Builder withHeaderStub(Supplier<String> headerStub) {
            this.headerStub = headerStub;
            return this;
        }

        @Generated
        Builder withLineFormat(Supplier<String> lineFormat) {
            this.lineFormat = lineFormat;
            return this;
        }

        @Generated
        Builder withFooterStub(Supplier<String> footerStub) {
            this.footerStub = footerStub;
            return this;
        }

        @Generated
        Builder withLines(List<HelpMessageLine> lines) {
            this.lines = lines;
            return this;
        }

        @Generated
        HelpMessage create() {
            return new HelpMessage(this.headerStub, this.lineFormat, this.footerStub, this.lines);
        }

        @Generated
        public String toString() {
            return "HelpMessage.Builder(headerStub=" + this.headerStub + ", lineFormat=" + this.lineFormat + ", footerStub=" + this.footerStub + ", lines=" + this.lines + ")";
        }
    }
}

