/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.command.easypayments.setup;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.command.CommandExecutor;
import ru.easydonate.easypayments.command.annotation.Arguments;
import ru.easydonate.easypayments.command.annotation.Command;
import ru.easydonate.easypayments.command.annotation.CommandAliases;
import ru.easydonate.easypayments.command.annotation.MinimalArgsCount;
import ru.easydonate.easypayments.command.annotation.Permission;
import ru.easydonate.easypayments.command.exception.ExecutionException;
import ru.easydonate.easypayments.command.exception.InitializationException;
import ru.easydonate.easypayments.core.config.Configuration;
import ru.easydonate.easypayments.core.config.localized.Messages;
import ru.easydonate.easypayments.core.formatting.StringFormatter;

@Command(value="access-key")
@CommandAliases(value={"shop-key", "key"})
@Arguments(value={"access-key"})
@MinimalArgsCount(value=1)
@Permission(value="easypayments.command.setup")
public final class CommandAccessKey
extends CommandExecutor {
    private final Configuration config;

    public CommandAccessKey(@NotNull Configuration config, @NotNull Messages messages) throws InitializationException {
        super(messages);
        this.config = config;
    }

    @Override
    public void executeCommand(@NotNull CommandSender sender, @NotNull List<String> args) throws ExecutionException {
        this.validateExecution(sender, args);
        String accessKey = args.get(0);
        if (accessKey.length() != 32) {
            throw new ExecutionException(this.messages.get("setup.failed.wrong-key-length", new Object[0]), new Object[0]);
        }
        if (!EasyPaymentsPlugin.ACCESS_KEY_REGEX.matcher(accessKey).matches()) {
            throw new ExecutionException(this.messages.get("setup.failed.wrong-key-regex", new Object[0]), new Object[0]);
        }
        this.config.getOverrides().put("key", accessKey);
        this.config.reload();
        String maskedKey = StringFormatter.maskAccessKey(accessKey);
        this.messages.getAndSend(sender, "setup.success.access-key", "%access_key%", maskedKey);
        if (this.config.getInt("server-id", 0) <= 0) {
            this.messages.getAndSend(sender, "setup.tips.server-id", new Object[0]);
        }
    }
}

