/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.command.easypayments;

import java.net.ConnectException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.command.CommandExecutor;
import ru.easydonate.easypayments.command.annotation.Arguments;
import ru.easydonate.easypayments.command.annotation.Command;
import ru.easydonate.easypayments.command.annotation.MinimalArgsCount;
import ru.easydonate.easypayments.command.annotation.Permission;
import ru.easydonate.easypayments.command.annotation.PluginEnableRequired;
import ru.easydonate.easypayments.command.exception.ExecutionException;
import ru.easydonate.easypayments.command.exception.InitializationException;
import ru.easydonate.easypayments.core.config.Configuration;
import ru.easydonate.easypayments.core.config.localized.Messages;
import ru.easydonate.easypayments.database.Database;
import ru.easydonate.easypayments.database.DatabaseManager;
import ru.easydonate.easypayments.database.DatabaseType;
import ru.easydonate.easypayments.database.model.Customer;
import ru.easydonate.easypayments.database.model.Payment;
import ru.easydonate.easypayments.database.model.Purchase;
import ru.easydonate.easypayments.database.persister.LocalDateTimePersister;
import ru.easydonate.easypayments.exception.CredentialsParseException;
import ru.easydonate.easypayments.exception.DriverLoadException;
import ru.easydonate.easypayments.exception.DriverNotFoundException;

@Command(value="migrate")
@Arguments(value={"database-type"})
@MinimalArgsCount(value=1)
@PluginEnableRequired
@Permission(value="easypayments.command.migrate")
public final class CommandMigrate
extends CommandExecutor {
    private static final List<String> AVAILABLE_TARGETS = Arrays.asList("sqlite", "h2", "mysql", "postgresql");
    private final EasyPaymentsPlugin plugin;
    private final Configuration config;

    public CommandMigrate(@NotNull EasyPaymentsPlugin plugin, @NotNull Configuration config, @NotNull Messages messages) throws InitializationException {
        super(messages);
        this.plugin = plugin;
        this.config = config;
    }

    @Override
    public void executeCommand(@NotNull CommandSender sender, @NotNull List<String> args) throws ExecutionException {
        this.validateExecution(sender, args);
        if (!EasyPaymentsPlugin.isStorageAvailable()) {
            throw new ExecutionException(this.messages.get("migrate.failed.storage-unavailable", new Object[0]), new Object[0]);
        }
        String rawType = args.get(0);
        DatabaseType destinationType = DatabaseType.getByKey(rawType);
        if (destinationType.isUnknown()) {
            throw new ExecutionException(this.messages.get("migrate.failed.unknown-target", new Object[0]), new Object[0]);
        }
        DatabaseType sourceType = this.plugin.getStorage().getDatabaseType();
        if (destinationType == sourceType) {
            throw new ExecutionException(this.messages.get("migrate.failed.same-target", new Object[0]), new Object[0]);
        }
        this.messages.getAndSend(sender, "migrate.starting", "%from%", sourceType.getName(), "%to%", destinationType.getName());
        CompletableFuture.runAsync(() -> this.migrateData(sender, destinationType));
    }

    private synchronized void migrateData(@NotNull CommandSender sender, @NotNull DatabaseType destinationType) {
        try {
            Database database = new Database(this.plugin, this.config, destinationType).registerTable(Customer.class).registerTable(Payment.class).registerTable(Purchase.class).registerPersister(LocalDateTimePersister.getSingleton()).complete();
            DatabaseManager destinationStorage = new DatabaseManager(this.plugin, this.config, database);
            DatabaseManager sourceStorage = this.plugin.getStorage();
            try {
                CompletableFuture<Integer> customers = destinationStorage.transferCustomersDataFrom(sourceStorage);
                CompletableFuture<Integer> payments = destinationStorage.transferPaymentsDataFrom(sourceStorage);
                CompletableFuture<Integer> purchases = destinationStorage.transferPurchasesDataFrom(sourceStorage);
                CompletableFuture.allOf(customers, payments, purchases).join();
                destinationStorage.shutdown();
                int customersAmount = this.outboxSafety(customers);
                int paymentsAmount = this.outboxSafety(payments);
                int purchasesAmount = this.outboxSafety(purchases);
                this.messages.getAndSend(sender, "migrate.success", "%from%", sourceStorage.getDatabaseType().getName(), "%to%", destinationStorage.getDatabaseType().getName(), "%customers_amount%", customersAmount, "%payments_amount%", paymentsAmount, "%purchases_amount%", purchasesAmount);
            }
            catch (Exception ex) {
                this.messages.getAndSend(sender, "migrate.failed.unexpected-error", "%message%", ex);
                this.plugin.getDebugLogger().error("[Migration] Unexpected error", new Object[0]);
                this.plugin.getDebugLogger().error(ex);
            }
        }
        catch (CredentialsParseException ex) {
            this.messages.getAndSend(sender, "migrate.failed.invalid-credentials", new Object[0]);
            this.plugin.getDebugLogger().error("[Migration] Credentials error", new Object[0]);
        }
        catch (DriverLoadException | DriverNotFoundException ex) {
            this.messages.getAndSend(sender, "migrate.failed.driver-load-failed", new Object[0]);
            this.plugin.getDebugLogger().error("[Migration] Driver error", new Object[0]);
            this.plugin.getDebugLogger().error(ex);
        }
        catch (SQLException ex) {
            for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof ConnectException)) continue;
                this.messages.getAndSend(sender, "migrate.failed.invalid-credentials", new Object[0]);
                return;
            }
            this.messages.getAndSend(sender, "migrate.failed.connection-failed", "%message%", ex);
            this.plugin.getDebugLogger().error("[Migration] SQL error", new Object[0]);
            this.plugin.getDebugLogger().error(ex);
        }
    }

    @Override
    @Nullable
    public List<String> provideTabCompletions(@NotNull CommandSender sender, @NotNull List<String> args) throws ExecutionException {
        this.validateExecution(sender, args);
        if (!EasyPaymentsPlugin.isStorageAvailable() || args.size() != 1) {
            return null;
        }
        String arg = args.get(0).toLowerCase();
        String current = this.plugin.getStorage().getDatabaseType().getKey();
        return AVAILABLE_TARGETS.stream().filter(s -> !s.equals(current)).filter(s -> s.startsWith(arg)).collect(Collectors.toList());
    }

    private int outboxSafety(@NotNull CompletableFuture<Integer> future) {
        Integer value = future.join();
        return value != null ? value : 0;
    }
}

