/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.command;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.command.CommandExecutor;
import ru.easydonate.easypayments.command.Executor;
import ru.easydonate.easypayments.command.exception.ExecutionException;
import ru.easydonate.easypayments.command.exception.InitializationException;
import ru.easydonate.easypayments.core.config.localized.Messages;

public abstract class CommandDispatcher
extends CommandExecutor {
    private final Map<String, Executor> registeredCommands = new LinkedHashMap<String, Executor>();

    public CommandDispatcher(@NotNull Messages messages) throws InitializationException {
        super(messages);
    }

    protected void onUsageWithoutArgs(@NotNull CommandSender sender) throws ExecutionException {
    }

    protected void registerChild(@NotNull Executor executor) {
        if (executor instanceof CommandExecutor) {
            ((CommandExecutor)executor).setParent(this);
        }
        String command = executor.getCommand();
        this.registeredCommands.put(command, executor);
        String[] aliases = executor.getAliases();
        if (aliases != null) {
            for (String alias : aliases) {
                this.registeredCommands.put(alias, executor);
            }
        }
    }

    @Override
    public void executeCommand(@NotNull CommandSender sender, @NotNull List<String> args) throws ExecutionException {
        if (args.isEmpty()) {
            this.onUsageWithoutArgs(sender);
            return;
        }
        String command = args.remove(0);
        Executor executor = this.findRelevantExecutor(command);
        if (executor == null) {
            throw new ExecutionException(this.messages.get("error.unknown-command", new Object[0]), new Object[0]);
        }
        executor.executeCommand(sender, args);
    }

    @Override
    @Nullable
    public List<String> provideTabCompletions(@NotNull CommandSender sender, @NotNull List<String> args) throws ExecutionException {
        if (args.isEmpty()) {
            return null;
        }
        if (args.size() == 1) {
            String input = args.get(0).toLowerCase();
            return this.registeredCommands.keySet().stream().filter(command -> command.toLowerCase().startsWith(input)).collect(Collectors.toList());
        }
        String command2 = args.remove(0);
        Executor executor = this.findRelevantExecutor(command2);
        return executor != null ? executor.provideTabCompletions(sender, args) : null;
    }

    @Nullable
    private Executor findRelevantExecutor(@Nullable String command) {
        if (command != null && !command.isEmpty()) {
            for (String registeredCommand : this.registeredCommands.keySet()) {
                if (!command.equalsIgnoreCase(registeredCommand)) continue;
                return this.registeredCommands.get(registeredCommand);
            }
        }
        return null;
    }
}

